/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.entity.monster;

import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.entity.monster.EntityElemental;
import cofh.thermalfoundation.entity.projectile.EntityBlitzBolt;
import cofh.thermalfoundation.init.TFSounds;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityBlitz
extends EntityElemental {
    static boolean enable = true;
    static boolean restrictLightLevel = true;
    static ResourceLocation lootTable;
    static int spawnLightLevel;
    static int spawnWeight;
    static int spawnMin;
    static int spawnMax;
    public static boolean effect;

    public static void initialize(int id) {
        EntityBlitz.config();
        lootTable = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("thermalfoundation", "entities/blitz"));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thermalfoundation:blitz"), EntityBlitz.class, (String)"thermalfoundation.blitz", (int)id, (Object)ThermalFoundation.instance, (int)64, (int)1, (boolean)true, (int)0xF0F8FF, (int)16773077);
        if (!enable) {
            return;
        }
        HashSet validBiomes = new HashSet();
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        validBiomes.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        validBiomes.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
        EntityRegistry.addSpawn(EntityBlitz.class, (int)spawnWeight, (int)spawnMin, (int)spawnMax, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])validBiomes.toArray(new Biome[validBiomes.size()]));
    }

    public static void config() {
        String category = "Mob.Blitz";
        String comment = "If TRUE, Blitzes will spawn naturally.";
        enable = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Enable", category, enable, comment);
        comment = "If TRUE, Blitzes will only spawn below a specified light level.";
        restrictLightLevel = ThermalFoundation.CONFIG.getConfiguration().getBoolean("LightLevelRestriction", category, restrictLightLevel, comment);
        comment = "This sets the maximum light level Blitzes can spawn at, if restricted.";
        spawnLightLevel = ThermalFoundation.CONFIG.getConfiguration().getInt("LightLevel", category, spawnLightLevel, 0, 15, comment);
        comment = "This sets the minimum number of Blitzes that spawn in a group.";
        spawnMin = ThermalFoundation.CONFIG.getConfiguration().getInt("MinGroupSize", category, spawnMin, 1, 10, comment);
        comment = "This sets the maximum number of Blitzes that spawn in a group.";
        spawnMax = ThermalFoundation.CONFIG.getConfiguration().getInt("MaxGroupSize", category, spawnMax, spawnMin, 24, comment);
        comment = "This sets the relative spawn weight for Blitzes.";
        spawnWeight = ThermalFoundation.CONFIG.getConfiguration().getInt("SpawnWeight", category, spawnWeight, 1, 20, comment);
        comment = "If TRUE, Blitz attacks will inflict Blindness.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
    }

    public EntityBlitz(World world) {
        super(world);
        this.ambientParticle = EnumParticleTypes.CLOUD;
        this.ambientSound = TFSounds.blitzAmbient;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return lootTable;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIBlitzBoltAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected boolean restrictLightLevel() {
        return restrictLightLevel;
    }

    @Override
    protected int getSpawnLightLevel() {
        return spawnLightLevel;
    }

    static {
        spawnLightLevel = 8;
        spawnWeight = 10;
        spawnMin = 1;
        spawnMax = 4;
        effect = true;
    }

    static class AIBlitzBoltAttack
    extends EntityAIBase {
        private final EntityBlitz blitz;
        private int attackStep;
        private int attackTime;

        public AIBlitzBoltAttack(EntityBlitz entity) {
            this.blitz = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.blitz.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.blitz.setInAttackMode(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase target = this.blitz.func_70638_az();
            double d0 = this.blitz.func_70068_e((Entity)target);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blitz.func_70652_k((Entity)target);
                }
                this.blitz.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance()) {
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                        this.blitz.setInAttackMode(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                        this.blitz.setInAttackMode(false);
                    }
                    if (this.attackStep > 1) {
                        this.blitz.field_70170_p.func_180498_a(null, 1009, new BlockPos((int)this.blitz.field_70165_t, (int)this.blitz.field_70163_u, (int)this.blitz.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntityBlitzBolt bolt = new EntityBlitzBolt(this.blitz.field_70170_p, (EntityLivingBase)this.blitz);
                            bolt.field_70163_u = this.blitz.field_70163_u + (double)(this.blitz.field_70131_O / 2.0f) + 0.5;
                            bolt.func_70186_c(target.field_70165_t - this.blitz.field_70165_t, target.field_70163_u - this.blitz.field_70163_u, target.field_70161_v - this.blitz.field_70161_v, 1.5f, 1.0f);
                            this.blitz.func_184185_a(TFSounds.blitzAttack, 2.0f, (this.blitz.field_70146_Z.nextFloat() - this.blitz.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                            this.blitz.field_70170_p.func_72838_d((Entity)bolt);
                        }
                    }
                }
                this.blitz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
            } else {
                this.blitz.func_70661_as().func_75499_g();
                this.blitz.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            IAttributeInstance attribute = this.blitz.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return attribute == null ? 16.0 : attribute.func_111126_e();
        }
    }
}

