/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.ThaumicAugmentationCore;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerWardBlockFlammability
extends Transformer {
    private static final String CLASS = "net.minecraft.block.Block";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return !ThaumicAugmentationCore.getConfig().getBoolean("DisableWardFocus", "gameplay.ward", false, "") && transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return false;
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode fire = TransformUtil.findMethod(classNode, "getFlammability", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I");
            boolean found = false;
            int ret = 0;
            while ((ret = TransformUtil.findFirstInstanceOfOpcode(fire, ret, 172)) != -1) {
                AbstractInsnNode insertAfter = fire.instructions.get(ret).getPrevious();
                fire.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardFlammability", "(ILnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", false));
                fire.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 2));
                fire.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
                ret += 4;
                found = true;
            }
            if (!found) {
                throw new TransformerException("Could not locate required instructions");
            }
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

