/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformUtil {
    public static final String HOOKS_COMMON = "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon";
    public static final String HOOKS_CLIENT = "thecodex6824/thaumicaugmentation/client/internal/TAHooksClient";

    private TransformUtil() {
    }

    public static String remapFieldName(String internalName, String fieldName) {
        String internal = FMLDeobfuscatingRemapper.INSTANCE.unmap(internalName);
        return FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(internal, fieldName, null);
    }

    public static String remapMethodName(String internalName, String methodName, Type returnType, Type ... parameterTypes) {
        String internal = FMLDeobfuscatingRemapper.INSTANCE.unmap(internalName);
        String desc = Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes);
        return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internal, methodName, desc);
    }

    public static MethodNode findMethod(ClassNode classNode, String name) {
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(name)) continue;
            return m;
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode classNode, String name, String desc) {
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
            return m;
        }
        return null;
    }

    public static int findFirstInstanceOfOpcode(MethodNode node, int startIndex, int opcode) {
        if (startIndex < 0 || startIndex >= node.instructions.size()) {
            return -1;
        }
        for (int i = startIndex; i < node.instructions.size(); ++i) {
            if (node.instructions.get(i).getOpcode() != opcode) continue;
            return i;
        }
        return -1;
    }

    public static int findLastInstanceOfOpcode(MethodNode node, int endIndex, int opcode) {
        if (endIndex - 1 < 0 || endIndex - 1 >= node.instructions.size()) {
            return -1;
        }
        for (int i = endIndex - 1; i >= 0; --i) {
            if (node.instructions.get(i).getOpcode() != opcode) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstInstanceOfMethodCall(MethodNode node, int startIndex, String name, String desc, String owningClass) {
        if (startIndex < 0 || startIndex >= node.instructions.size()) {
            return -1;
        }
        for (int i = startIndex; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode method = (MethodInsnNode)insn;
            if (!method.name.equals(name) || !method.desc.equals(desc) || !method.owner.equals(owningClass)) continue;
            return i;
        }
        return -1;
    }

    public static int findLastInstanceOfMethodCall(MethodNode node, int endIndex, String name, String desc, String owningClass) {
        if (endIndex - 1 < 0 || endIndex - 1 >= node.instructions.size()) {
            return -1;
        }
        for (int i = endIndex - 1; i >= 0; --i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode method = (MethodInsnNode)insn;
            if (!method.name.equals(name) || !method.desc.equals(desc) || !method.owner.equals(owningClass)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstLabel(MethodNode node, int startIndex) {
        if (startIndex < 0 || startIndex >= node.instructions.size()) {
            return -1;
        }
        for (int i = startIndex; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof LabelNode)) continue;
            return i;
        }
        return -1;
    }

    public static int findLastLabel(MethodNode node, int endIndex) {
        if (endIndex - 1 < 0 || endIndex - 1 >= node.instructions.size()) {
            return -1;
        }
        for (int i = endIndex - 1; i >= 0; --i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof LabelNode)) continue;
            return i;
        }
        return -1;
    }

    public static int findLineNumber(MethodNode node, int number) {
        for (int i = 0; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof LineNumberNode) || ((LineNumberNode)insn).line != number) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstField(MethodNode node, int startIndex, String name, String desc, String owningClass) {
        if (startIndex < 0 || startIndex >= node.instructions.size()) {
            return -1;
        }
        for (int i = startIndex; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode field = (FieldInsnNode)insn;
            if (!field.name.equals(name) || !field.desc.equals(desc) || !field.owner.equals(owningClass)) continue;
            return i;
        }
        return -1;
    }

    public static int findLastField(MethodNode node, int endIndex, String name, String desc, String owningClass) {
        if (endIndex - 1 < 0 || endIndex - 1 >= node.instructions.size()) {
            return -1;
        }
        for (int i = endIndex - 1; i >= 0; --i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode field = (FieldInsnNode)insn;
            if (!field.name.equals(name) || !field.desc.equals(desc) || !field.owner.equals(owningClass)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstLoad(MethodNode node, int startIndex, int opcode, int objIndex) {
        if (startIndex < 0 || startIndex >= node.instructions.size()) {
            return -1;
        }
        for (int i = startIndex; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (insn.getOpcode() != opcode || !(insn instanceof VarInsnNode)) continue;
            VarInsnNode var = (VarInsnNode)insn;
            if (var.var != objIndex) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstInstanceOf(MethodNode node, int startIndex, String desc) {
        if (startIndex < 0 || startIndex >= node.instructions.size()) {
            return -1;
        }
        for (int i = startIndex; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (insn.getOpcode() != 193 || !(insn instanceof TypeInsnNode)) continue;
            TypeInsnNode t = (TypeInsnNode)insn;
            if (!t.desc.equals(desc)) continue;
            return i;
        }
        return -1;
    }

    public static int findExactLabel(MethodNode node, Label label) {
        for (int i = 0; i < node.instructions.size(); ++i) {
            LabelNode l;
            AbstractInsnNode insn = node.instructions.get(i);
            if (!(insn instanceof LabelNode) || !(l = (LabelNode)insn).getLabel().equals(label)) continue;
            return i;
        }
        return -1;
    }
}

