/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.feature;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import thaumcraft.api.ThaumcraftMaterials;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.world.BiomeTerrainBlocks;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.api.world.capability.CapabilityFractureLocations;
import thecodex6824.thaumicaugmentation.api.world.capability.IFractureLocations;
import thecodex6824.thaumicaugmentation.common.entity.EntityDimensionalFracture;
import thecodex6824.thaumicaugmentation.common.util.FractureLocatorSearchManager;
import thecodex6824.thaumicaugmentation.common.world.WorldDataCache;
import thecodex6824.thaumicaugmentation.common.world.feature.FractureUtils;

public class WorldGenDimensionalFracture
extends WorldGenerator {
    private static final int WORLD_BORDER_MAX = 29999984;

    protected void func_175903_a(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 18);
    }

    protected static boolean isMaterialReplaceable(Material mat) {
        return mat == Material.field_151579_a || mat == Material.field_151577_b || mat == Material.field_151578_c || mat == Material.field_151576_e || mat == Material.field_151595_p || mat == Material.field_151597_y || mat == Material.field_151571_B || mat == ThaumcraftMaterials.MATERIAL_TAINT;
    }

    protected void generateBiomeTerrain(World world, Random rand, BlockPos fracture, BiomeTerrainBlocks.TerrainBlocks blocks) {
        if (((ChunkProviderServer)world.func_72863_F()).func_193413_a(world, "EldritchSpire", fracture.func_177979_c(2))) {
            return;
        }
        int depth = rand.nextInt(2) + 1;
        for (int x = -5; x < 6; ++x) {
            for (int y = 5; y > -6 - depth; --y) {
                for (int z = -5; z < 6; ++z) {
                    int chanceFactor;
                    BlockPos pos = fracture.func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (Math.abs(x) < 2 && Math.abs(y) < 2 && Math.abs(z) < 2) {
                        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || !(state.func_185887_b(world, pos) >= 0.0f)) continue;
                        this.func_175903_a(world, pos, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) >= 9 || (world.func_175623_d(pos) || !WorldGenDimensionalFracture.isMaterialReplaceable(state.func_185904_a())) && y >= -1 || state.func_185904_a().func_76224_d() || !(state.func_185887_b(world, pos) >= 0.0f) || (chanceFactor = Math.abs(x * x) + Math.abs(y) + Math.abs(z * z)) >= 5 && rand.nextInt(chanceFactor - 4) != 0) continue;
                    IBlockState up = world.func_180495_p(pos.func_177984_a());
                    this.func_175903_a(world, pos, up.func_177230_c().isAir(up, (IBlockAccess)world, pos.func_177984_a()) ? blocks.getTopState() : blocks.getFillerState());
                }
            }
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        if (world.field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
            BlockPos scaled;
            WorldDataCache.WorldData dim = FractureUtils.pickRandomDimension(rand, FractureUtils.calcMaxSafeFactor(TAConfig.emptinessMoveFactor.getValue(), position.func_177958_n() >> 4, position.func_177952_p() >> 4));
            if (dim != null && Math.abs((scaled = FractureUtils.scaleBlockPosFromEmptiness(position, dim.getMovementFactor(), dim.getWorldSeed())).func_177958_n()) < 29999984 && Math.abs(scaled.func_177952_p()) < 29999984) {
                Biome linkedBiome = dim.getBiomeProvider().func_180631_a(scaled);
                this.generateBiomeTerrain(world, rand, position, BiomeTerrainBlocks.getTerrainBlocksForBiome(linkedBiome));
                BlockPos placeAt = new BlockPos(position.func_177958_n(), position.func_177956_o() - 1, position.func_177952_p());
                EntityDimensionalFracture fracture = new EntityDimensionalFracture(world);
                fracture.func_70012_b((double)placeAt.func_177958_n() + 0.5, placeAt.func_177956_o(), (double)placeAt.func_177952_p() + 0.5, rand.nextInt(360), 0.0f);
                fracture.setLinkedDimension(dim.getDimensionID());
                fracture.setLinkedPosition(scaled);
                fracture.setDestinationBiome(linkedBiome);
                world.func_72838_d((Entity)fracture);
                IFractureLocations loc = (IFractureLocations)world.func_175726_f(placeAt).getCapability(CapabilityFractureLocations.FRACTURE_LOCATIONS, null);
                if (loc != null) {
                    loc.addFractureLocation(placeAt);
                    FractureLocatorSearchManager.addFractureLocation(world, placeAt);
                }
                return true;
            }
        } else {
            BlockPos scaled;
            WorldDataCache.WorldData dim = WorldDataCache.getData(TADimensions.EMPTINESS.func_186068_a());
            if (dim != null && Math.abs((scaled = FractureUtils.scaleBlockPosToEmptiness(position, world.field_73011_w.getMovementFactor(), dim.getWorldSeed())).func_177958_n()) < 29999984 && Math.abs(scaled.func_177952_p()) < 29999984) {
                Biome linkedBiome = dim.getBiomeProvider().func_180631_a(scaled);
                this.generateBiomeTerrain(world, rand, position, BiomeTerrainBlocks.getTerrainBlocksForBiome(linkedBiome));
                BlockPos placeAt = new BlockPos(position.func_177958_n(), position.func_177956_o() - 1, position.func_177952_p());
                EntityDimensionalFracture fracture = new EntityDimensionalFracture(world);
                fracture.func_70012_b((double)placeAt.func_177958_n() + 0.5, placeAt.func_177956_o(), (double)placeAt.func_177952_p() + 0.5, rand.nextInt(360), 0.0f);
                fracture.setLinkedDimension(dim.getDimensionID());
                fracture.setLinkedPosition(scaled);
                fracture.setDestinationBiome(linkedBiome);
                world.func_72838_d((Entity)fracture);
                IFractureLocations loc = (IFractureLocations)world.func_175726_f(placeAt).getCapability(CapabilityFractureLocations.FRACTURE_LOCATIONS, null);
                if (loc != null) {
                    loc.addFractureLocation(placeAt);
                    FractureLocatorSearchManager.addFractureLocation(world, placeAt);
                }
                return true;
            }
        }
        return false;
    }
}

