/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class TileCreativeImpetusSink
extends TileEntity
implements ITickable {
    protected SimpleImpetusConsumer consumer = new SimpleImpetusConsumer(Integer.MAX_VALUE, 0);
    protected int ticks = ThreadLocalRandom.current().nextInt(20);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 20 == 0) {
            ConsumeResult result = this.consumer.consume(Long.MAX_VALUE, false);
            if (result.energyConsumed > 0L) {
                NodeHelper.syncAllImpetusTransactions(result.paths.keySet());
                for (Map.Entry<Deque<IImpetusNode>, Long> entry : result.paths.entrySet()) {
                    NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        this.consumer.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.consumer);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.consumer);
        }
        this.consumer.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.consumer.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.consumer.init(this.field_145850_b);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.consumer.deserializeNBT(nbt.func_74775_l("node"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityImpetusNode.IMPETUS_NODE || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.consumer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

