/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.block.property.IAltarBlock;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGolem;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchWarden;
import thecodex6824.thaumicaugmentation.common.entity.IEldritchSpireWardHolder;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

public class TileAltar
extends TileEntity
implements ITickable,
IInteractWithCaster {
    protected static final BlockPos[] CAP_OFFSETS = new BlockPos[]{new BlockPos(-1, 0, -3), new BlockPos(-3, 0, -1), new BlockPos(-3, 0, 1), new BlockPos(-1, 0, 3), new BlockPos(1, 0, 3), new BlockPos(3, 0, 1), new BlockPos(3, 0, -1), new BlockPos(1, 0, -3)};
    protected int openTicks = Integer.MIN_VALUE;
    protected boolean research;

    public void open() {
        this.openTicks = 280;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public boolean isOpen() {
        return this.openTicks != Integer.MIN_VALUE;
    }

    public int getOpenTicks() {
        return this.openTicks;
    }

    public boolean isStructureAltar() {
        return this.research;
    }

    public void setStructureAltar(boolean structure) {
        this.research = structure;
    }

    protected EntityLiving createBoss() {
        if (this.field_145850_b.field_73012_v.nextBoolean()) {
            return new EntityTAEldritchGolem(this.field_145850_b);
        }
        return new EntityTAEldritchWarden(this.field_145850_b);
    }

    public void func_73660_a() {
        if (this.openTicks > 0) {
            --this.openTicks;
        }
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state;
            BlockPos check;
            if (this.research) {
                for (EntityPlayer player : this.field_145850_b.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(9.0, 3.0, 9.0), Predicates.and((Predicate)Predicates.notNull(), (Predicate)EntitySelectors.field_180132_d))) {
                    RayTraceResult result;
                    if (ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_BOSSROOM"}) || (result = this.field_145850_b.func_147447_a(player.func_174824_e(1.0f), new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.15, (double)this.field_174879_c.func_177952_p() + 0.5), false, false, false)) != null) continue;
                    ThaumcraftCapabilities.getKnowledge((EntityPlayer)player).addResearch("m_BOSSROOM");
                    player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.boss_room_spire", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            }
            if (this.openTicks == 0) {
                MapGenStructureData data;
                check = this.field_174879_c.func_177981_b(2);
                state = this.field_145850_b.func_180495_p(check);
                if (state.func_177230_c() == TABlocks.OBELISK) {
                    this.field_145850_b.func_175655_b(check, false);
                }
                EntityLiving boss = this.createBoss();
                boss.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                boss.field_70759_as = boss.field_70177_z;
                boss.field_70761_aq = boss.field_70177_z;
                if (boss instanceof IEldritchSpireWardHolder && (data = (MapGenStructureData)this.field_145850_b.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "EldritchSpire")) != null) {
                    NBTTagCompound nbt = data.func_143041_a();
                    for (String s : nbt.func_150296_c()) {
                        StructureStart start;
                        NBTTagCompound tag = nbt.func_74775_l(s);
                        if (!tag.func_150297_b("ChunkX", 3) || !tag.func_150297_b("ChunkZ", 3) || !((start = MapGenStructureIO.func_143035_a((NBTTagCompound)tag, (World)this.field_145850_b)) instanceof MapGenEldritchSpire.Start) || !start.func_75071_a().func_175898_b((Vec3i)this.field_174879_c)) continue;
                        ((IEldritchSpireWardHolder)boss).setStructurePos(new DimensionalBlockPos(new BlockPos(start.func_143019_e() << 4, 0, start.func_143018_f() << 4), this.field_145850_b.field_73011_w.getDimension()));
                    }
                }
                boss.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
                if (this.field_145850_b.func_72838_d((Entity)boss)) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, TASounds.ALTAR_SUMMON, SoundCategory.BLOCKS, 1.5f, 1.0f);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.EXPLOSION, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5), (Entity)boss);
                }
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
            } else if (this.openTicks <= 140 && this.openTicks > 60 && this.openTicks % 10 == 0) {
                check = this.field_174879_c.func_177971_a((Vec3i)CAP_OFFSETS[this.openTicks / 10 - 7]);
                state = this.field_145850_b.func_180495_p(check);
                if (state.func_177230_c() == TABlocks.CAPSTONE && !((Boolean)state.func_177229_b((IProperty)IAltarBlock.ALTAR)).booleanValue()) {
                    this.field_145850_b.func_175655_b(check, false);
                }
            } else if (this.openTicks == 175) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.shock, SoundCategory.BLOCKS, 0.5f, 0.85f);
            } else if (this.openTicks == 250) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.evilportal, SoundCategory.BLOCKS, 0.25f, 1.0f);
            }
        }
    }

    public boolean onCasterRightClick(World world, ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing facing, EnumHand hand) {
        if (!world.field_72995_K && world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            this.open();
            world.func_184133_a(null, pos, SoundsTC.wand, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_184133_a(null, pos, TASounds.ALTAR_SUMMON_START, SoundCategory.BLOCKS, 1.5f, 1.0f);
        }
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || (Boolean)newState.func_177229_b((IProperty)IAltarBlock.ALTAR) == false;
    }

    public double func_145833_n() {
        return 16384.0;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(1.0, 0.0, 1.0).func_72321_a(0.0, 2.0, 0.0);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74768_a("openTicks", this.openTicks);
        return tag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("openTicks", this.openTicks);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.openTicks = pkt.func_148857_g().func_74762_e("openTicks");
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("openTicks", this.openTicks);
        compound.func_74757_a("structureAltar", this.research);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.openTicks = compound.func_74762_e("openTicks");
        this.research = compound.func_74767_n("structureAltar");
    }
}

