/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;

public class PacketLivingEquipmentChange
implements IMessage {
    protected static final int MAX_NBT_SIZE = 0x200000;
    protected int entity;
    protected EntityEquipmentSlot slot;
    protected ItemStack stack;

    public PacketLivingEquipmentChange() {
    }

    public PacketLivingEquipmentChange(int entityID, EntityEquipmentSlot equipSlot, ItemStack newStack) {
        this.entity = entityID;
        this.slot = equipSlot;
        this.stack = newStack.func_77946_l();
    }

    protected EntityEquipmentSlot slotFromIndex(int slotIndex) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188452_c() != slotIndex) continue;
            return slot;
        }
        return EntityEquipmentSlot.MAINHAND;
    }

    public void fromBytes(ByteBuf buf) {
        this.entity = buf.readInt();
        this.slot = this.slotFromIndex(buf.readInt());
        int itemID = buf.readInt();
        if (itemID >= 0) {
            int count = buf.readInt();
            int meta = buf.readInt();
            this.stack = new ItemStack(Item.func_150899_d((int)itemID), count, meta);
            int payloadSize = buf.readInt();
            if (payloadSize > 0) {
                byte[] buffer = new byte[Math.min(payloadSize, 0x200000)];
                buf.readBytes(buffer, 0, buffer.length);
                try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(buffer));){
                    this.stack.func_77973_b().readNBTShareTag(this.stack, CompressedStreamTools.func_74794_a((DataInputStream)stream));
                }
                catch (IOException ex) {
                    ThaumicAugmentation.getLogger().warn("Unable to deserialize PacketLivingEquipmentChange: " + ex.getMessage());
                }
            }
        } else {
            this.stack = ItemStack.field_190927_a;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entity);
        buf.writeInt(this.slot.func_188452_c());
        if (this.stack.func_190926_b()) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(Item.func_150891_b((Item)this.stack.func_77973_b()));
            buf.writeInt(this.stack.func_190916_E());
            buf.writeInt(this.stack.func_77960_j());
            if (this.stack.func_77984_f() || this.stack.func_77973_b().func_77651_p()) {
                NBTTagCompound tag = this.stack.func_77973_b().getNBTShareTag(this.stack);
                if (tag != null) {
                    byte[] tagBuffer = null;
                    try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                         DataOutputStream output = new DataOutputStream(bytes);){
                        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
                        tagBuffer = bytes.toByteArray();
                    }
                    catch (IOException ex) {
                        ThaumicAugmentation.getLogger().warn("Unable to serialize PacketLivingEquipmentChange: " + ex.getMessage());
                    }
                    buf.writeInt(Math.min(tagBuffer.length, 0x200000));
                    buf.writeBytes(tagBuffer, 0, Math.min(tagBuffer.length, 0x200000));
                } else {
                    buf.writeInt(-1);
                }
            } else {
                buf.writeInt(-1);
            }
        }
    }

    public int getEntityID() {
        return this.entity;
    }

    public EntityEquipmentSlot getSlot() {
        return this.slot;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

