/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;

public class PacketAugmentableItemSync
implements IMessage {
    private int id;
    private int index;
    private NBTTagCompound nbt;

    public PacketAugmentableItemSync() {
    }

    public PacketAugmentableItemSync(int entityID, int i, NBTTagCompound sync) {
        this.id = entityID;
        this.index = i;
        this.nbt = sync;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.index = buf.readInt();
        try {
            byte[] buffer = new byte[buf.readInt()];
            buf.readBytes(buffer);
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            this.nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        catch (IOException ex) {
            ThaumicAugmentation.getLogger().warn("Unable to deserialize PacketAugmentableItemSync: " + ex.getMessage());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.index);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.nbt, (OutputStream)stream);
            byte[] data = stream.toByteArray();
            buf.writeInt(data.length);
            buf.writeBytes(data);
        }
        catch (IOException ex) {
            ThaumicAugmentation.getLogger().warn("Unable to serialize PacketAugmentableItemSync: " + ex.getMessage());
        }
    }

    public NBTTagCompound getTagCompound() {
        return this.nbt;
    }

    public int getItemIndex() {
        return this.index;
    }

    public int getEntityID() {
        return this.id;
    }
}

