/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.config;

import com.jaquadro.minecraft.chameleon.config.ConfigSection;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.config.EnumToggle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigManagerExt {
    private final Configuration config;
    private final ConfigSection.Common sectionMaster;
    private final ConfigSection sectionGeneral;
    private final ConfigSection sectionMods;
    private final Map<EnumMod, EnumToggle> modToggleCache = new HashMap<EnumMod, EnumToggle>();

    public ConfigManagerExt(File file) {
        this.config = new Configuration(file);
        this.sectionMaster = new ConfigSection.Common(this.config, "storagedrawersextra.config.");
        this.sectionGeneral = new ConfigSection(this.sectionMaster, "general", "general");
        this.sectionMods = new ConfigSection(this.sectionMaster, "mods", "mods");
        for (ConfigSection section : this.sectionMaster.getSections()) {
            section.getCategory();
        }
        this.syncConfig();
    }

    public ConfigSection.Common getSectionMaster() {
        return this.sectionMaster;
    }

    public void syncConfig() {
        for (EnumMod mod : EnumMod.values()) {
            Property prop = this.config.get(this.sectionMods.getQualifiedName(), mod.func_176610_l(), "auto", null, new String[]{"auto", "enabled", "disabled"}).setLanguageKey(this.sectionMaster.getLangPrefix() + "mods." + mod.func_176610_l()).setRequiresMcRestart(true);
            this.modToggleCache.put(mod, EnumToggle.fromString(prop.getString()));
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public EnumToggle getModToggleState(EnumMod mod) {
        EnumToggle result = this.modToggleCache.get((Object)mod);
        if (result == null) {
            result = EnumToggle.AUTO;
        }
        return result;
    }
}

