/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.item.ItemFluxpack;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.network.NetworkHandler;

public class MessageKeybind
implements IMessage,
IMessageHandler<MessageKeybind, IMessage> {
    public JetpackPacket packetType;

    public MessageKeybind() {
    }

    public MessageKeybind(JetpackPacket type) {
        this.packetType = type;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.packetType.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.packetType = JetpackPacket.values()[buf.readInt()];
    }

    public IMessage onMessage(MessageKeybind msg, MessageContext ctx) {
        EntityPlayerMP entityPlayerMP = ctx.getServerHandler().field_147369_b;
        WorldServer worldServer = entityPlayerMP.func_71121_q();
        worldServer.func_152344_a(() -> this.handleMessage(msg, ctx));
        return null;
    }

    public void handleMessage(MessageKeybind msg, MessageContext ctx) {
        EntityPlayer player = NetworkHandler.getPlayer(ctx);
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (stack.func_77973_b() instanceof ItemJetpack) {
            ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();
            if (msg.packetType == JetpackPacket.ENGINE) {
                jetpack.toggleState(jetpack.isOn(stack), stack, "engine_mode", "JetpackEngine", player, Config.enableStateMessages);
            } else if (msg.packetType == JetpackPacket.CHARGER) {
                jetpack.toggleState(jetpack.isChargerOn(stack), stack, "charger_mode", "JetpackCharger", player, Config.enableStateMessages);
            } else if (msg.packetType == JetpackPacket.HOVER) {
                jetpack.toggleState(jetpack.isHoverModeOn(stack), stack, "hover_mode", "JetpackHover", player, Config.enableStateMessages);
            } else if (msg.packetType == JetpackPacket.E_HOVER) {
                jetpack.toggleState(jetpack.isEHoverModeOn(stack), stack, "emergency_hover_mode", "JetpackEHover", player, Config.enableStateMessages);
            }
        } else if (stack.func_77973_b() instanceof ItemFluxpack) {
            ItemFluxpack fluxpack = (ItemFluxpack)stack.func_77973_b();
            if (msg.packetType == JetpackPacket.ENGINE) {
                fluxpack.toggleState(fluxpack.isOn(stack), stack, "engine_mode", "FluxpackEngine", player, Config.enableStateMessages);
            }
        }
    }

    public static enum JetpackPacket {
        ENGINE,
        CHARGER,
        HOVER,
        E_HOVER;

    }
}

