/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import com.google.common.collect.Sets;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.config.RunedWoodConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.tileentity.TileEntityCatalystPlate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualUtil {
    private static Random rand = Util.rand;
    public static AxisAlignedBB CATALYST = new AxisAlignedBB(-6.0, -6.0, -6.0, 7.0, 7.0, 7.0);
    public static AxisAlignedBB RADIUS = new AxisAlignedBB(-9.0, -9.0, -9.0, 10.0, 10.0, 10.0);

    public static BlockPos getRandomPosRadialXZ(BlockPos centerPos, int xRadius, int zRadius) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(centerPos.func_177958_n() - xRadius, centerPos.func_177956_o(), centerPos.func_177952_p() - zRadius);
        return pos.func_177982_a(rand.nextInt(xRadius * 2), 0, rand.nextInt(zRadius * 2));
    }

    public static BlockPos getRandomGroundPosition(BlockPos center, int xRadius, int zRadius) {
        int randX = rand.nextInt(xRadius * 2) - xRadius;
        int randZ = rand.nextInt(zRadius * 2) - zRadius;
        return center.func_177982_a(randX, 0, randZ);
    }

    public static BlockPos getRandomPosRadialXYZ(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
        BlockPos pos = new BlockPos(centerPos.func_177958_n() - xRadius, centerPos.func_177956_o() - yRadius, centerPos.func_177952_p() - zRadius);
        pos = pos.func_177982_a(rand.nextInt(xRadius * 2), rand.nextInt(yRadius * 2), rand.nextInt(zRadius * 2));
        return pos;
    }

    @Nullable
    public static BlockPos getRandomPosRadialXYZ(World world, BlockPos centerPos, int xRadius, int yRadius, int zRadius, Block ... whitelistedBlocks) {
        BlockPos pos = new BlockPos(centerPos.func_177958_n() - xRadius, centerPos.func_177956_o() - yRadius, centerPos.func_177952_p() - zRadius);
        HashSet blocks = Sets.newHashSet((Object[])whitelistedBlocks);
        for (int i = 0; i < xRadius * yRadius * zRadius; ++i) {
            IBlockState state = world.func_180495_p(pos = pos.func_177982_a(xRadius > 0 ? rand.nextInt(xRadius * 2) : 0, yRadius > 0 ? rand.nextInt(yRadius * 2) : 0, zRadius > 0 ? rand.nextInt(zRadius * 2) : 0));
            if (!blocks.contains(state.func_177230_c())) continue;
            return pos;
        }
        return null;
    }

    public static int getRandomInteger(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static boolean isAdjacentToWater(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            if (!GeneralConfig.getWaterBlocks().contains(block)) continue;
            return true;
        }
        return false;
    }

    public static List<TileEntityCatalystPlate> getNearbyCatalystPlates(World world, BlockPos pos) {
        AxisAlignedBB bounds = CATALYST.func_186670_a(pos);
        BlockPos max = RitualUtil.max(bounds);
        BlockPos min = RitualUtil.min(bounds);
        ArrayList<TileEntityCatalystPlate> result = new ArrayList<TileEntityCatalystPlate>();
        for (BlockPos p : BlockPos.func_177975_b((BlockPos)max, (BlockPos)min)) {
            TileEntity te;
            IBlockState state;
            if (world.func_175623_d(p) || (state = world.func_180495_p(p)).func_177230_c() != ModBlocks.catalyst_plate && state.func_177230_c() != ModBlocks.reinforced_catalyst_plate || !((te = world.func_175625_s(p)) instanceof TileEntityCatalystPlate)) continue;
            result.add((TileEntityCatalystPlate)te);
        }
        return result;
    }

    public static List<ItemStack> getItemsFromNearbyPlates(List<TileEntityCatalystPlate> plates) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (TileEntityCatalystPlate plate : plates) {
            ItemStack stack = plate.getHeldItem();
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static int getNearbyStandingStones(World world, BlockPos pos, int height) {
        return RitualUtil.getNearbyPositions(Runestone.get(), world, pos, height).size();
    }

    public static int getNearbyPillar(StandingPillar pillar, World world, BlockPos pos, int height) {
        return RitualUtil.getNearbyPositions(pillar, world, pos, height).size();
    }

    public static List<BlockPos> getNearbyPositions(StandingPillar pillar, World world, BlockPos pos, int height) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        AxisAlignedBB bounds = RADIUS.func_186670_a(pos);
        BlockPos max = RitualUtil.max(bounds);
        BlockPos min = RitualUtil.min(bounds);
        for (BlockPos p : BlockPos.func_177975_b((BlockPos)max, (BlockPos)min)) {
            IBlockState startState;
            IBlockState state = world.func_180495_p(p);
            if (!pillar.matchesTop(state)) continue;
            BlockPos start = p.func_185334_h().func_177977_b();
            int column = 1;
            while (start.func_177956_o() > p.func_177956_o() - 10 && pillar.matchesBase(startState = world.func_180495_p(start))) {
                start = start.func_177977_b();
                ++column;
            }
            if (column != height && (height != -1 || column < 3)) continue;
            positions.add(p.func_185334_h());
        }
        return positions;
    }

    public static BlockPos min(AxisAlignedBB box) {
        return new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c);
    }

    public static BlockPos max(AxisAlignedBB box) {
        return new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public static enum RunedWoodType implements StandingPillar
    {
        ACACIA(RunedWoodConfig.ACACIA),
        OAK(RunedWoodConfig.OAK),
        DARK_OAK(RunedWoodConfig.DARK_OAK),
        BIRCH(RunedWoodConfig.BIRCH),
        JUNGLE(RunedWoodConfig.JUNGLE),
        SPRUCE(RunedWoodConfig.SPRUCE),
        WILDWOOD(RunedWoodConfig.WILDWOOD);

        private final RunedWoodConfig.RunedPillarConfig config;

        private RunedWoodType(RunedWoodConfig.RunedPillarConfig config) {
            this.config = config;
        }

        public ItemStack getVisual() {
            return this.config.getItemStack();
        }

        public IBlockState getBase() {
            return this.config.getPillarState();
        }

        public Block getTopper() {
            return this.config.getCapstoneState().func_177230_c();
        }

        @Override
        public boolean matchesBase(IBlockState state) {
            return this.config.getPillarMatcher().test(state);
        }

        @Override
        public boolean matchesTop(IBlockState state) {
            return this.config.getCapstoneMatcher().test(state);
        }

        @Nullable
        public static IBlockState matchesAny(IBlockState state) {
            for (RunedWoodType type : RunedWoodType.values()) {
                if (!type.matchesBase(state)) continue;
                return type.getTopper().func_176223_P();
            }
            return null;
        }
    }

    public static class Runestone
    implements StandingPillar {
        private static Runestone INSTANCE = null;
        private static Set<Block> toppers = new HashSet<Block>();
        private static Set<Block> bases = new HashSet<Block>();

        public Runestone() {
            if (toppers.isEmpty()) {
                toppers.add(ModBlocks.chiseled_runestone);
                toppers.add(ModBlocks.chiseled_runed_obsidian);
            }
            if (bases.isEmpty()) {
                bases.add(ModBlocks.runestone);
                bases.add(ModBlocks.runed_obsidian);
            }
        }

        public static Runestone get() {
            if (INSTANCE == null) {
                INSTANCE = new Runestone();
            }
            return INSTANCE;
        }

        @Override
        public boolean matchesBase(IBlockState state) {
            return bases.contains(state.func_177230_c());
        }

        @Override
        public boolean matchesTop(IBlockState state) {
            return toppers.contains(state.func_177230_c());
        }
    }

    public static interface StandingPillar {
        public boolean matchesBase(IBlockState var1);

        public boolean matchesTop(IBlockState var1);
    }
}

