/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCatalystPlate
extends TileBase {
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityCatalystPlate.this.func_70296_d();
            if (!((TileEntityCatalystPlate)TileEntityCatalystPlate.this).field_145850_b.field_72995_K) {
                TileEntityCatalystPlate.this.updatePacketViaState();
            }
        }
    };
    private UUID lastPlayer = null;
    private int progress = 0;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        if (this.lastPlayer != null) {
            tag.func_74782_a("lastPlayer", (NBTBase)NBTUtil.func_186862_a((UUID)this.lastPlayer));
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("lastPlayer")) {
            this.lastPlayer = NBTUtil.func_186860_b((NBTTagCompound)tag.func_74775_l("lastPlayer"));
        }
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        this.progress = tag.func_74762_e("progress");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack inSlot;
        ItemStack heldItem = player.func_184586_b(hand);
        this.lastPlayer = player.func_110124_au();
        this.func_70296_d();
        int count = heldItem.func_190916_E();
        if (!heldItem.func_190926_b()) {
            inSlot = this.inventory.getStackInSlot(0);
            boolean doInsert = false;
            if (!inSlot.func_190926_b() && ItemUtil.equalWithoutSize((ItemStack)inSlot, (ItemStack)heldItem) && inSlot.func_190916_E() < inSlot.func_77976_d()) {
                if (player.func_70093_af()) {
                    count = Math.min(inSlot.func_77976_d() - inSlot.func_190916_E(), heldItem.func_190916_E());
                }
                doInsert = true;
            } else if (inSlot.func_190926_b()) {
                doInsert = true;
            }
            if (doInsert) {
                ItemStack toInsert = heldItem.func_77946_l();
                toInsert.func_190920_e(count);
                ItemStack attemptedInsert = this.inventory.insertItem(0, toInsert, true);
                if (attemptedInsert.func_190926_b()) {
                    if (!world.field_72995_K) {
                        this.inventory.insertItem(0, toInsert, false);
                        player.func_184586_b(hand).func_190918_g(count);
                        if (player.func_184586_b(hand).func_190916_E() == 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        this.updatePacketViaState();
                    }
                    return true;
                }
            }
        }
        inSlot = this.inventory.getStackInSlot(0);
        if ((heldItem.func_190926_b() || ItemUtil.equalWithoutSize((ItemStack)heldItem, (ItemStack)inSlot)) && !world.field_72995_K && hand == EnumHand.MAIN_HAND && !inSlot.func_190926_b()) {
            count = inSlot.func_190916_E();
            if (player.func_70093_af()) {
                count = 1;
            }
            ItemStack extracted = this.inventory.extractItem(0, count, false);
            ItemUtil.spawnItem((World)world, (BlockPos)this.func_174877_v(), (ItemStack)extracted);
            this.updatePacketViaState();
            return true;
        }
        return false;
    }

    public ItemStack getHeldItem() {
        return this.inventory.getStackInSlot(0).func_77946_l();
    }

    public ItemStack removeItem() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b() == ModItems.life_essence) {
            if (stack.func_96631_a(1, Util.rand, null)) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }
        ItemStack ingredient = stack.func_77946_l();
        ingredient.func_190920_e(1);
        stack.func_190918_g(1);
        if (stack.func_190916_E() == 0 || stack.func_190926_b()) {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        } else {
            this.inventory.setStackInSlot(0, stack);
        }
        return ingredient;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public UUID getLastPlayer() {
        return this.lastPlayer;
    }
}

