/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info.storage;

import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.SpellDustInfo;
import epicsquid.roots.spell.info.storage.AbstractSpellStorage;
import epicsquid.roots.util.SpellUtil;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DustSpellStorage
extends AbstractSpellStorage<SpellDustInfo> {
    private SpellDustInfo info = null;

    public DustSpellStorage() {
    }

    protected DustSpellStorage(ItemStack stack) {
        super(stack);
    }

    @Override
    public boolean hasSpellInSlot() {
        return this.info != null;
    }

    @Override
    public boolean isEmpty() {
        return this.info != null;
    }

    @Override
    public boolean isValid() {
        return SpellUtil.isValidDust(this.stack);
    }

    @Override
    @Nullable
    public SpellDustInfo getSpellInSlot(int slot) {
        return this.info;
    }

    @Override
    public void clearSelectedSlot() {
        this.info = null;
        this.saveToStack();
    }

    @Override
    public void clearSlot(int slot) {
        this.clearSelectedSlot();
    }

    @Override
    public void previousSlot() {
    }

    @Override
    public void nextSlot() {
    }

    public void setSpellToSlot(SpellBase spell) {
        SpellDustInfo info = new SpellDustInfo(spell);
        this.addSpell(info);
    }

    @Override
    public void addSpell(SpellDustInfo spell) {
        this.info = spell;
        this.saveToStack();
    }

    @Override
    public void setSpellToSlot(int slot, SpellDustInfo spell) {
        this.addSpell(spell);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        if (this.info == null) {
            return new NBTTagCompound();
        }
        return this.info.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        this.info = SpellDustInfo.fromNBT(tag);
    }

    @Nullable
    public static DustSpellStorage fromStack(ItemStack stack) {
        return DustSpellStorage.fromStack(stack, DustSpellStorage::new);
    }
}

