/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info;

import epicsquid.roots.spell.FakeSpell;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class AbstractSpellInfo
implements INBTSerializable<NBTTagCompound> {
    protected SpellBase spell;

    public AbstractSpellInfo() {
    }

    public AbstractSpellInfo(SpellBase spell) {
        this.spell = spell;
    }

    @Nullable
    public SpellBase getSpell() {
        return this.spell;
    }

    @Nonnull
    public SpellBase getNonNullSpell() {
        if (this.spell == null) {
            return FakeSpell.INSTANCE;
        }
        return this.spell;
    }

    public static SpellBase getSpellFromTag(NBTTagCompound nbt) {
        String name = nbt.func_74779_i("s");
        if (name.contains(":")) {
            return SpellRegistry.getSpell(new ResourceLocation(name));
        }
        return SpellRegistry.getSpell(name);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = new NBTTagCompound();
        if (this.spell != null) {
            result.func_74778_a("s", this.spell.getRegistryName().toString());
        }
        return result;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        String name;
        this.spell = nbt.func_74764_b("s") ? ((name = nbt.func_74779_i("s")).contains(":") ? SpellRegistry.getSpell(new ResourceLocation(name)) : SpellRegistry.getSpell(name)) : null;
    }

    public abstract boolean isEmpty();

    public abstract ItemStack asStack();
}

