/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.AABBUtil;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.RayCastUtil;
import epicsquid.roots.config.MossConfig;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageRunicShearsAOEFX;
import epicsquid.roots.network.fx.MessageShatterBurstFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellHarvest;
import epicsquid.roots.spell.SpellNaturesScythe;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellShatter
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(0);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("stalicripe", 0.25));
    public static Property<Float> PROP_DISTANCE = new Property<Float>("distance", Float.valueOf(8.0f)).setDescription("the maximum range of the beam");
    public static Property<Integer> PROP_DEFAULT_WIDTH = new Property<Integer>("default_width", 0).setDescription("the default width (when not amplified; 0 = 1)");
    public static Property<Integer> PROP_DEFAULT_HEIGHT = new Property<Integer>("default_height", 0).setDescription("the default height (when not amplified: this is 2 blocks tall, with the block below the block targeted also being broken; if this value is greater than 0, than the height will be 1 block above and 1 block below, relatively, th block hit)");
    public static Property<Integer> PROP_DEFAULT_DEPTH = new Property<Integer>("default_depth", 0).setDescription("the default depth (when not amplified; 0 = just one block broken)");
    public static Property<Integer> PROP_WIDTH = new Property<Integer>("width", 1).setDescription("the width when the width modifier is applied; this is appiled to the left and right of the targeted block, meaning a width of 1 is a total width of 3 blocks");
    public static Property<Integer> PROP_HEIGHT = new Property<Integer>("height", 1).setDescription("the height when the height modifier is applied; as per width");
    public static Property<Integer> PROP_DEPTH = new Property<Integer>("depth", 2).setDescription("this value is applied by offsetting the position relative to the angle the beam struck it; if struck from above, it digs down, etc. By default, with a value single 2, this should result in 3 blocks being broken.");
    public static Modifier WIDER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "wider"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.45)));
    public static Modifier TALLER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "taller"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.45)));
    public static Modifier MAGNETISM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "magnetic_ray"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.125)));
    public static Modifier DEEPER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "deeper"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.45)));
    public static Modifier SINGLE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "singularity"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.125)));
    public static Modifier KNIFE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "moss_harvest"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.275)));
    public static Modifier VOID = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "shatter_void"), ModifierCores.BAFFLE_CAP, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.345))));
    public static Modifier FORTUNE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "shatter_fortune"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.375)));
    public static Modifier SMELTING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "smelting_ray"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.25)));
    public static Modifier SILK_TOUCH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "shatter_silk_touch"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.65)));
    public static ResourceLocation spellName;
    public static SpellShatter instance;
    public float distance;
    private int default_depth;
    private int added_depth;
    private int default_height;
    private int added_height;
    private int default_width;
    private int added_width;
    private int fortune;

    public SpellShatter(ResourceLocation name) {
        super(name, TextFormatting.GRAY, 0.3764706f, 0.3764706f, 0.3764706f, 0.7529412f, 0.7529412f, 0.7529412f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_DISTANCE, PROP_DEPTH, PROP_WIDTH, PROP_HEIGHT, PROP_DEFAULT_DEPTH, PROP_DEFAULT_HEIGHT, PROP_DEFAULT_WIDTH);
        this.acceptModifiers(WIDER, TALLER, MAGNETISM, DEEPER, SINGLE, KNIFE, VOID, FORTUNE, SMELTING, SILK_TOUCH);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Items.field_151145_ak), new ItemStack(Items.field_151050_s), new ItemStack(ModItems.stalicripe), new ItemStack(Item.func_150898_a((Block)Blocks.field_150335_W)), new OreIngredient("cobblestone"));
        this.setCastSound(ModSounds.Spells.SHATTER);
    }

    @Nullable
    public static AxisAlignedBB getBox(EntityPlayer player, StaffModifierInstanceList info, RayTraceResult result) {
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            int d;
            BlockPos pos = result.func_178782_a();
            EnumFacing side = result.field_178784_b;
            EnumFacing playerFacing = player.func_174811_aO();
            EnumFacing width = EnumFacing.func_176733_a((double)(playerFacing.func_185119_l() + 90.0f));
            EnumFacing height = side.func_176740_k() != EnumFacing.Axis.Y ? EnumFacing.DOWN : playerFacing.func_176734_d();
            EnumFacing depth = side.func_176734_d();
            BlockPos start = pos;
            BlockPos stop = pos;
            if (!info.has(SINGLE)) {
                int w;
                int h;
                int n = h = info.has(TALLER) ? SpellShatter.instance.added_height : SpellShatter.instance.default_height;
                if (info.has(TALLER)) {
                    stop = stop.func_177967_a(height, h);
                    start = start.func_177967_a(height.func_176734_d(), h);
                } else if (!info.has(WIDER)) {
                    stop = stop.func_177972_a(height);
                }
                int n2 = w = info.has(WIDER) ? SpellShatter.instance.added_width : SpellShatter.instance.default_width;
                if (w != 0) {
                    stop = stop.func_177967_a(width, w);
                    start = start.func_177967_a(width.func_176734_d(), w);
                }
            }
            int n = d = info.has(DEEPER) ? SpellShatter.instance.added_depth : SpellShatter.instance.default_depth;
            if (d != 0) {
                stop = stop.func_177967_a(depth, d);
            }
            return new AxisAlignedBB(start, stop);
        }
        return null;
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        AxisAlignedBB box;
        Vec3d eyes = new Vec3d(0.0, (double)player.func_70047_e(), 0.0);
        RayTraceResult result = RayCastUtil.rayTraceBlocks((World)player.field_70170_p, (Vec3d)player.func_174791_d().func_178787_e(eyes), (Vec3d)player.func_70040_Z().func_186678_a((double)this.distance).func_178787_e(player.func_174791_d().func_178787_e(eyes)), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ArrayList<Function<ItemStack, ItemStack>> converters = new ArrayList<Function<ItemStack, ItemStack>>();
        if (info.has(SMELTING)) {
            converters.add(SpellHarvest.instance::tryCook);
        }
        if ((box = SpellShatter.getBox(player, info, result)) == null) {
            return false;
        }
        boolean broke = false;
        ArrayList<BlockPos> mossPositions = new ArrayList<BlockPos>();
        boolean noMoss = MossConfig.getBlacklistDimensions().contains(player.field_70170_p.field_73011_w.getDimension());
        for (BlockPos p : AABBUtil.unique((AxisAlignedBB)box)) {
            IBlockState mossState;
            IBlockState state = player.field_70170_p.func_180495_p(p);
            boolean didMoss = false;
            if (info.has(KNIFE) && !noMoss && (mossState = MossConfig.scrapeResult(state)) != null) {
                broke = true;
                didMoss = true;
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_175656_a(p, mossState);
                    player.field_70170_p.func_180497_b(p, mossState.func_177230_c(), 1, mossState.func_177230_c().func_149738_a(player.field_70170_p));
                    mossPositions.add(p);
                    if (info.has(MAGNETISM)) {
                        ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)new ItemStack(ModItems.terra_moss));
                    } else {
                        ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)p, (ItemStack)new ItemStack(ModItems.terra_moss));
                    }
                }
            }
            if (didMoss || (!info.has(SILK_TOUCH) || !SpellNaturesScythe.instance.canSilkTouch(player.field_70170_p, p, state, player)) && !(state.func_185887_b(player.field_70170_p, p) > 0.0f)) continue;
            if (!player.field_70170_p.field_72995_K) {
                if (info.has(VOID)) {
                    player.field_70170_p.func_175655_b(p, false);
                } else {
                    SpellNaturesScythe.instance.breakBlock(player.field_70170_p, p, info, player, converters);
                }
            }
            broke = true;
        }
        if (broke) {
            if (!player.field_70170_p.field_72995_K) {
                double yaw = Math.toRadians(-90.0 - (double)player.field_70177_z);
                double offX = 0.5 * Math.sin(yaw);
                double offZ = 0.5 * Math.cos(yaw);
                PacketHandler.sendToAllTracking((IMessage)new MessageShatterBurstFX(player.field_70165_t + offX, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v + offZ, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c), (Entity)player);
                if (!mossPositions.isEmpty()) {
                    MessageRunicShearsAOEFX message = new MessageRunicShearsAOEFX(mossPositions);
                    PacketHandler.sendToAllTracking((IMessage)message, (int)player.field_70170_p.field_73011_w.getDimension(), (BlockPos)((BlockPos)mossPositions.get(0)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.distance = this.properties.get(PROP_DISTANCE).floatValue();
        this.default_depth = this.properties.get(PROP_DEFAULT_DEPTH);
        this.added_depth = this.properties.get(PROP_DEPTH);
        this.default_height = this.properties.get(PROP_DEFAULT_HEIGHT);
        this.added_height = this.properties.get(PROP_HEIGHT);
        this.default_width = this.properties.get(PROP_DEFAULT_WIDTH);
        this.added_width = this.properties.get(PROP_WIDTH);
    }

    static {
        SILK_TOUCH.addConflict(FORTUNE);
        spellName = new ResourceLocation("roots", "spell_shatter");
        instance = new SpellShatter(spellName);
    }
}

