/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageSaturationFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.OreDictCache;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SpellSaturate
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(500);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("wildewheet", 0.425));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.65));
    public static Property<Double> PROP_SATURATION_MULTIPLIER = new Property<Double>("saturation_multiplier", 0.5).setDescription("multiplier for the saturation value each food item gives");
    public static Property<Double> PROP_FOOD_MULTIPLIER = new Property<Double>("food_multiplier", 0.5).setDescription("multiplier for the food value each food item gives");
    public static Property<Double> PROP_ADDITIONAL_SATURATION_MULTIPLIER = new Property<Double>("increased_saturation_multiplier", 0.3).setDescription("the additional value added to the multiplier");
    public static Property<Double> PROP_ADDITIONAL_FOOD_MULTIPLIER = new Property<Double>("increased_food_multiplier", 0.3);
    public static Property<String> PROP_UNCOOKED_DICT = new Property<String>("uncooked_dictionary", "rootsUncookedVegetables").setDescription("the ore dictionary name for items that should be considered uncooked vegetables");
    public static Property<Double> PROP_UNCOOKED_ADDITIONAL_SATURATION = new Property<Double>("uncooked_saturation", 0.4).setDescription("how much additional saturation ratio uncooked food should provide");
    public static Property<Double> PROP_UNCOOKED_ADDITIONAL_FOOD = new Property<Double>("uncooked_food", 0.4).setDescription("how much additional food ratio uncooked food should provide");
    public static Property<String> PROP_COOKED_DICT = new Property<String>("cooked_dictionary", "rootsCookedFoods").setDescription("the ore dictionary name for items that should be considered cooked");
    public static Property<Double> PROP_COOKED_ADDITIONAL_SATURATION = new Property<Double>("cooked_saturation", 0.4).setDescription("how much additional saturation ratio cooked food should provide");
    public static Property<Double> PROP_COOKED_ADDITIONAL_FOOD = new Property<Double>("cooked_food", 0.4).setDescription("how much additional food ratio cooked food should provide");
    public static Property<String> PROP_BOTTLED_DICT = new Property<String>("bottled_dictionary", "rootsBottledFood").setDescription("the ore dictionary name for items that should be considered bottled goods");
    public static Property<Double> PROP_BOTTLED_ADDITIONAL_SATURATION = new Property<Double>("bottled_saturation", 0.4).setDescription("how much additional saturation ratio bottled food should provide");
    public static Property<Double> PROP_BOTTLED_ADDITIONAL_FOOD = new Property<Double>("bottled_food", 0.4).setDescription("how much additional food ratio bottled food should provide");
    public static Property<Integer> PROP_RESISTANCE_DURATION = new Property<Integer>("resistance_duration", 200).setDescription("the duration of the resistance effect, multiplied by how much additional saturation there is");
    public static Property<Integer> PROP_RESISTANCE_AMPLIFIER = new Property<Integer>("resistance_amplifier", 0).setDescription("the amplifier for the resistance effect");
    public static Property<Double> PROP_POISON_ADDITION_FOOD = new Property<Double>("poison_food", 0.7).setDescription("how much additional percentage of food should be applied when eating poisoned food");
    public static Property<Double> PROP_POISON_ADDITION_SATURATION = new Property<Double>("poison_saturation", 0.7).setDescription("how much additional percentage of saturation should be applied when eating poisoned food");
    public static Property<Double> PROP_NAUSEA_ADDITIONAL_FOOD = new Property<Double>("nausea_food", 0.7).setDescription("how much additional percentage of food should be applied when eating sickening food");
    public static Property<Double> PROP_NAUSEA_ADDITIONAL_SATURATION = new Property<Double>("nausea_saturation", 0.7).setDescription("how much additional percentage of saturation should be applied when eating sickening food");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 6).setDescription("radius on the X axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("radius on the Y axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 6).setDescription("radius on the Z axis of the area the spell has effect on");
    public static Property<Integer> PROP_INVERSION_SATURATION_BOOST = new Property<Integer>("inversion_saturation_boost", 5).setDescription("the value that the percentage ratio between max foot/saturation and the food/saturation value is added from; set lower to cause inversion to give less food");
    public static Property<Integer> PROP_INVERSION_FOOD_BOOST = new Property<Integer>("inversion_food_boost", 4).setDescription("the value that the percentage ratio between max foot/saturation and the food/saturation value is added from; set lower to cause inversion to give less food (rounded down)");
    public static Modifier RATIO = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "big_bellied"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.6)));
    public static Modifier UNCOOKED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "root_lover"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.345)));
    public static Modifier INVERSION = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "inversion"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.345)));
    public static Modifier RESISTANCE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "iron_excess"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.275)));
    public static Modifier POISONED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "antivenom"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.275)));
    public static Modifier ITEMS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "scattered_goods"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.125)));
    public static Modifier COOKED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "cooked_goods"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.275)));
    public static Modifier NAUSEA = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "iron_gut"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.275)));
    public static Modifier BOTTLED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "bottled_goods"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.275)));
    public static ResourceLocation spellName;
    public static SpellSaturate instance;
    private String uncooked_dictionary;
    private String cooked_dictionary;
    private String bottled_dictionary;
    private int resistance_amplifier;
    private int resistance_duration;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private int inversion_food_boost;
    private int inversion_saturation_boost;
    private double saturation_multiplier;
    private double food_multiplier;
    private double additional_saturation_multiplier;
    private double additional_food_multiplier;
    private double poison_saturation;
    private double poison_food;
    private double uncooked_saturation;
    private double uncooked_food;
    private double cooked_saturation;
    private double cooked_food;
    private double bottled_saturation;
    private double bottled_food;
    private double nausea_saturation;
    private double nausea_food;
    private boolean suppressSound = false;

    public SpellSaturate(ResourceLocation name) {
        super(name, TextFormatting.GOLD, 0.88235295f, 0.20392157f, 0.9647059f, 5.5238094f, 0.9098039f, 0.16470589f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_SATURATION_MULTIPLIER, PROP_FOOD_MULTIPLIER, PROP_ADDITIONAL_FOOD_MULTIPLIER, PROP_ADDITIONAL_SATURATION_MULTIPLIER, PROP_UNCOOKED_DICT, PROP_RESISTANCE_AMPLIFIER, PROP_RESISTANCE_DURATION, PROP_POISON_ADDITION_FOOD, PROP_POISON_ADDITION_SATURATION, PROP_COOKED_ADDITIONAL_FOOD, PROP_COOKED_ADDITIONAL_SATURATION, PROP_COOKED_DICT, PROP_UNCOOKED_ADDITIONAL_FOOD, PROP_UNCOOKED_ADDITIONAL_SATURATION, PROP_NAUSEA_ADDITIONAL_FOOD, PROP_NAUSEA_ADDITIONAL_SATURATION, PROP_BOTTLED_ADDITIONAL_FOOD, PROP_BOTTLED_ADDITIONAL_SATURATION, PROP_BOTTLED_DICT, PROP_INVERSION_SATURATION_BOOST, PROP_INVERSION_FOOD_BOOST, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z);
        this.acceptModifiers(RATIO, UNCOOKED, INVERSION, RESISTANCE, POISONED, ITEMS, COOKED, NAUSEA, BOTTLED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Items.field_151009_A), new ItemStack(Items.field_151117_aB), new ItemStack(epicsquid.mysticalworld.init.ModItems.cooked_aubergine), new ItemStack(Items.field_151110_aK), new ItemStack(ModItems.wildewheet));
        this.setCastSound(ModSounds.Spells.SATURATE);
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        World world = caster.field_70170_p;
        FoodStats stats = caster.func_71024_bL();
        int currentFood = stats.func_75116_a();
        double currentSat = stats.func_75115_e();
        if (currentSat >= 20.0 && currentFood >= 20) {
            return false;
        }
        double newSat = currentSat;
        int newFood = currentFood;
        IItemHandler handler = (IItemHandler)caster.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        Object2IntOpenHashMap foods = new Object2IntOpenHashMap();
        for (int i = 0; i < Objects.requireNonNull(handler).getSlots(); ++i) {
            ItemStack inSlot = handler.getStackInSlot(i);
            if (!(inSlot.func_77973_b() instanceof ItemFood)) continue;
            foods.put((Object)inSlot, i);
        }
        ArrayList<EntityItem> entities = new ArrayList<EntityItem>();
        if (info.has(ITEMS)) {
            entities.addAll(Util.getEntitiesWithinRadius((World)caster.field_70170_p, EntityItem.class, (BlockPos)caster.func_180425_c(), (float)this.radius_x, (float)this.radius_y, (float)this.radius_z));
            entities.removeIf(o -> !(o.func_92059_d().func_77973_b() instanceof ItemFood));
        }
        if (foods.isEmpty() && (entities.isEmpty() || !info.has(ITEMS))) {
            return false;
        }
        entities.sort((o1, o2) -> Double.compare(this.saturation(o2.func_92059_d(), info), this.saturation(o1.func_92059_d(), info)));
        List sortedFoods = foods.keySet().stream().sorted((o1, o2) -> Double.compare(this.saturation((ItemStack)o2, info), this.saturation((ItemStack)o1, info))).collect(Collectors.toList());
        Object2IntOpenHashMap usedFoods = new Object2IntOpenHashMap();
        for (ItemStack stack : sortedFoods) {
            double thisSaturation = this.saturation(stack, info);
            int thisFood = this.health(stack, info);
            int used = 0;
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                ++used;
                if ((newSat += thisSaturation) >= 20.0 && (newFood += thisFood) >= 20) break;
            }
            if (used > 0) {
                usedFoods.put((Object)stack, used);
            }
            if (!(newSat >= 20.0) || newFood < 20) continue;
            break;
        }
        ArrayList<EntityItem> usedItems = new ArrayList<EntityItem>();
        ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
        if (info.has(ITEMS)) {
            for (EntityItem item : entities) {
                ItemStack stack = item.func_92059_d();
                double thisSaturation = this.saturation(stack, info);
                int thisFood = this.health(stack, info);
                int used = 0;
                for (int i = 0; i < stack.func_190916_E(); ++i) {
                    ++used;
                    if ((newSat += thisSaturation) >= 20.0 && (newFood += thisFood) >= 20) break;
                }
                if (used > 0) {
                    if (!caster.field_70170_p.field_72995_K) {
                        ItemStack stack2 = stack.func_77946_l();
                        stack2.func_190920_e(used);
                        consumedStacks.add(stack2);
                        stack.func_190918_g(used);
                    }
                    usedItems.add(item);
                }
                if (!(newSat >= 20.0) || newFood < 20) continue;
                break;
            }
            if (!caster.field_70170_p.field_72995_K) {
                for (EntityItem item : usedItems) {
                    if (!item.func_92059_d().func_190926_b()) continue;
                    caster.field_70170_p.func_72900_e((Entity)item);
                }
            }
        }
        if (newSat <= currentSat && newFood <= currentFood) {
            return false;
        }
        if (usedFoods.isEmpty() && usedItems.isEmpty()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        this.suppressSound = true;
        PotionEffect poison = null;
        PotionEffect hunger = null;
        PotionEffect blindness = null;
        PotionEffect wither = null;
        PotionEffect nausea = null;
        if (info.has(POISONED)) {
            poison = caster.func_70660_b(MobEffects.field_76436_u);
            caster.func_184596_c(MobEffects.field_76436_u);
        }
        if (info.has(NAUSEA)) {
            nausea = caster.func_70660_b(MobEffects.field_76431_k);
            caster.func_184596_c(MobEffects.field_76431_k);
            hunger = caster.func_70660_b(MobEffects.field_76438_s);
            caster.func_184596_c(MobEffects.field_76438_s);
            blindness = caster.func_70660_b(MobEffects.field_76440_q);
            caster.func_184596_c(MobEffects.field_76440_q);
            wither = caster.func_70660_b(MobEffects.field_82731_v);
            caster.func_184596_c(MobEffects.field_82731_v);
        }
        for (Object2IntMap.Entry entry : usedFoods.object2IntEntrySet()) {
            int used = entry.getIntValue();
            ItemStack stack = (ItemStack)entry.getKey();
            int index = foods.getInt((Object)stack);
            ItemStack result = handler.extractItem(index, used, false);
            if (result.func_190926_b()) continue;
            containers.addAll(this.handleContainers(caster, info, result));
        }
        for (ItemStack result : consumedStacks) {
            containers.addAll(this.handleContainers(caster, info, result));
        }
        if (info.has(POISONED)) {
            caster.func_184589_d(MobEffects.field_76436_u);
            if (poison != null) {
                caster.func_70690_d(poison);
            }
        }
        if (info.has(NAUSEA)) {
            caster.func_184589_d(MobEffects.field_76438_s);
            caster.func_184589_d(MobEffects.field_76431_k);
            caster.func_184589_d(MobEffects.field_76440_q);
            caster.func_184589_d(MobEffects.field_82731_v);
            if (hunger != null) {
                caster.func_70690_d(hunger);
            }
            if (wither != null) {
                caster.func_70690_d(wither);
            }
            if (nausea != null) {
                caster.func_70690_d(nausea);
            }
            if (blindness != null) {
                caster.func_70690_d(blindness);
            }
        }
        this.suppressSound = false;
        if ((double)stats.field_75125_b < newSat) {
            stats.field_75125_b = (float)Math.min(20.0, newSat);
        }
        if (stats.func_75116_a() < newFood) {
            stats.func_75114_a(Math.min(20, newFood));
        }
        if (!containers.isEmpty()) {
            for (ItemStack container : containers) {
                if (caster.func_191521_c(container)) continue;
                ItemUtil.spawnItem((World)caster.field_70170_p, (BlockPos)caster.func_180425_c(), (ItemStack)container);
            }
        }
        if (info.has(RESISTANCE)) {
            double excessSat = newFood - 20;
            int excessFood = newFood - 20;
            if (excessSat > 0.0 || excessFood > 0) {
                int amount = MathHelper.func_76143_f((double)excessSat) * Math.min(1, excessFood);
                caster.func_70690_d(new PotionEffect(MobEffects.field_76429_m, amount * this.resistance_duration, this.resistance_amplifier, false, false));
            }
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)caster;
        playerMP.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(playerMP.func_110143_aJ(), playerMP.func_71024_bL().func_75116_a(), playerMP.func_71024_bL().func_75115_e()));
        MessageSaturationFX message = new MessageSaturationFX(caster);
        PacketHandler.sendToAllTracking((IMessage)message, (Entity)caster);
        return true;
    }

    private List<ItemStack> handleContainers(EntityPlayer caster, StaffModifierInstanceList info, ItemStack result) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (int i = 0; i < result.func_190916_E(); ++i) {
            ItemStack container = result.func_77950_b(caster.field_70170_p, (EntityLivingBase)caster);
            if (container.func_190926_b() || ItemUtil.equalWithoutSize((ItemStack)container, (ItemStack)result)) continue;
            containers.add(container);
        }
        return containers;
    }

    private boolean poisoned(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return false;
        }
        ItemFood food = (ItemFood)stack.func_77973_b();
        return food.field_77851_ca != null && food.field_77851_ca.func_188419_a() == MobEffects.field_76436_u;
    }

    private boolean nauseating(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return false;
        }
        ItemFood food = (ItemFood)stack.func_77973_b();
        if (food.field_77851_ca != null) {
            if (food.field_77851_ca.func_188419_a() == MobEffects.field_76431_k) {
                return true;
            }
            if (food.field_77851_ca.func_188419_a() == MobEffects.field_76438_s) {
                return true;
            }
            if (food.field_77851_ca.func_188419_a() == MobEffects.field_76440_q) {
                return true;
            }
            return food.field_77851_ca.func_188419_a() == MobEffects.field_82731_v;
        }
        return false;
    }

    private boolean cooked(ItemStack stack) {
        return OreDictCache.matches(this.cooked_dictionary, stack);
    }

    private boolean uncooked(ItemStack stack) {
        return OreDictCache.matches(this.uncooked_dictionary, stack);
    }

    private boolean bottled(ItemStack stack) {
        return OreDictCache.matches(this.bottled_dictionary, stack);
    }

    private double inversion(double value, int boost) {
        return value + (double)boost * ((20.0 - value) / 20.0);
    }

    private double saturation(ItemStack stack, StaffModifierInstanceList info) {
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return 0.0;
        }
        ItemFood item = (ItemFood)stack.func_77973_b();
        int heal = item.func_150905_g(stack);
        float saturation = item.func_150906_h(stack);
        double sat = this.saturation_multiplier;
        if (info.has(RATIO)) {
            sat += this.additional_saturation_multiplier;
        }
        if (info.has(POISONED) && this.poisoned(stack)) {
            sat += this.poison_saturation;
        }
        if (info.has(NAUSEA) && this.nauseating(stack)) {
            sat += this.nausea_saturation;
        }
        if (info.has(COOKED) && this.cooked(stack)) {
            sat += this.cooked_saturation;
        }
        if (info.has(UNCOOKED) && this.uncooked(stack)) {
            sat += this.uncooked_saturation;
        }
        if (info.has(BOTTLED) && this.bottled(stack)) {
            sat += this.bottled_saturation;
        }
        double result = (double)((float)heal * saturation * 2.0f) * sat;
        if (info.has(INVERSION)) {
            result = this.inversion(result, this.inversion_saturation_boost);
        }
        return result;
    }

    private int health(ItemStack stack, StaffModifierInstanceList info) {
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return 0;
        }
        ItemFood item = (ItemFood)stack.func_77973_b();
        double food = this.food_multiplier;
        if (info.has(RATIO)) {
            food += this.additional_food_multiplier;
        }
        if (info.has(POISONED) && this.poisoned(stack)) {
            food += this.poison_food;
        }
        if (info.has(NAUSEA) && this.nauseating(stack)) {
            food += this.nausea_food;
        }
        if (info.has(COOKED) && this.cooked(stack)) {
            food += this.cooked_food;
        }
        if (info.has(UNCOOKED) && this.uncooked(stack)) {
            food += this.uncooked_food;
        }
        if (info.has(BOTTLED) && this.bottled(stack)) {
            food += this.bottled_food;
        }
        double result = (double)item.func_150905_g(stack) * food;
        if (info.has(INVERSION)) {
            result = this.inversion(result, this.inversion_food_boost);
        }
        return MathHelper.func_76128_c((double)result);
    }

    @SubscribeEvent
    public void onSoundPlayed(PlaySoundAtEntityEvent event) {
        if (event.getCategory() == SoundCategory.PLAYERS && event.getSound() == SoundEvents.field_187739_dZ && this.suppressSound) {
            event.setCanceled(true);
        }
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.saturation_multiplier = this.properties.get(PROP_SATURATION_MULTIPLIER);
        this.food_multiplier = this.properties.get(PROP_FOOD_MULTIPLIER);
        this.additional_food_multiplier = this.properties.get(PROP_ADDITIONAL_FOOD_MULTIPLIER);
        this.additional_saturation_multiplier = this.properties.get(PROP_ADDITIONAL_SATURATION_MULTIPLIER);
        this.uncooked_dictionary = this.properties.get(PROP_UNCOOKED_DICT);
        this.resistance_amplifier = this.properties.get(PROP_RESISTANCE_AMPLIFIER);
        this.resistance_duration = this.properties.get(PROP_RESISTANCE_DURATION);
        this.poison_food = this.properties.get(PROP_POISON_ADDITION_FOOD);
        this.poison_saturation = this.properties.get(PROP_POISON_ADDITION_SATURATION);
        this.uncooked_saturation = this.properties.get(PROP_UNCOOKED_ADDITIONAL_SATURATION);
        this.uncooked_food = this.properties.get(PROP_UNCOOKED_ADDITIONAL_FOOD);
        this.cooked_saturation = this.properties.get(PROP_COOKED_ADDITIONAL_SATURATION);
        this.cooked_food = this.properties.get(PROP_COOKED_ADDITIONAL_FOOD);
        this.cooked_dictionary = this.properties.get(PROP_COOKED_DICT);
        this.bottled_saturation = this.properties.get(PROP_BOTTLED_ADDITIONAL_SATURATION);
        this.bottled_food = this.properties.get(PROP_BOTTLED_ADDITIONAL_FOOD);
        this.bottled_dictionary = this.properties.get(PROP_BOTTLED_DICT);
        this.nausea_saturation = this.properties.get(PROP_NAUSEA_ADDITIONAL_SATURATION);
        this.nausea_food = this.properties.get(PROP_NAUSEA_ADDITIONAL_FOOD);
        this.inversion_food_boost = this.properties.get(PROP_INVERSION_FOOD_BOOST);
        this.inversion_saturation_boost = this.properties.get(PROP_INVERSION_SATURATION_BOOST);
    }

    static {
        UNCOOKED.addConflicts(INVERSION, POISONED, COOKED, NAUSEA, BOTTLED);
        INVERSION.addConflicts(POISONED, COOKED, NAUSEA, BOTTLED);
        POISONED.addConflicts(COOKED, NAUSEA, BOTTLED);
        COOKED.addConflicts(NAUSEA, BOTTLED);
        NAUSEA.addConflict(BOTTLED);
        spellName = new ResourceLocation("roots", "spell_saturate");
        instance = new SpellSaturate(spellName);
    }
}

