/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import com.google.common.collect.Sets;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.block.BlockColoredFeyLight;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreIngredient;

public class SpellFeyLight
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(20);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("cloud_berry", 0.125));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("radius on the X axis within which lights are affected by the spell");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 10).setDescription("radius on the Y axis within which lights are affected by the spell");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("radius on the Z axis within which lights are affected by the spell");
    public static Modifier PINK = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "pink_light"), ModifierCores.PERESKIA, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier YELLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "yellow_light"), ModifierCores.WILDEWHEET, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier FIXED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "fixed_light"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.125)));
    public static Modifier PURPLE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "purple_light"), ModifierCores.MOONGLOW_LEAF, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier CONSUME = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "deluminator"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.475)));
    public static Modifier GREEN = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "green_light"), ModifierCores.TERRA_MOSS, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier DECAY = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "decaying_light"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.275)));
    public static Modifier RED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "red_light"), ModifierCores.INFERNAL_BULB, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier BROWN = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "brown_light"), ModifierCores.STALICRIPE, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier BLUE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "blue_light"), ModifierCores.DEWGONIA, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static ResourceLocation spellName;
    public static SpellFeyLight instance;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private AxisAlignedBB box;
    private static Set<Block> lightSet;

    public SpellFeyLight(ResourceLocation name) {
        super(name, TextFormatting.LIGHT_PURPLE, 0.96862745f, 0.9647059f, 0.8235294f, 0.8901961f, 0.31764707f, 0.95686275f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z);
        this.acceptModifiers(PINK, YELLOW, FIXED, PURPLE, CONSUME, GREEN, DECAY, RED, BROWN, BLUE);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Item.func_150898_a((Block)Blocks.field_150428_aP)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150398_cm), 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()), new ItemStack(ModItems.cloud_berry), new OreIngredient("rootsBark"), new ItemStack(ModItems.cloud_berry));
        this.setCastSound(ModSounds.Spells.FEY_LIGHT);
    }

    public int nextTick() {
        return 75 + Util.rand.nextInt(75);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        World world = player.field_70170_p;
        if (info.has(CONSUME)) {
            List positions;
            if (lightSet == null) {
                lightSet = Sets.newHashSet((Object[])new Block[]{ModBlocks.fey_colored_light, ModBlocks.fey_decaying_light, ModBlocks.fey_light});
            }
            if ((positions = Util.getBlocksWithinRadius((World)world, (BlockPos)player.func_180425_c(), (float)this.radius_x, (float)this.radius_y, (float)this.radius_z, lightSet)).isEmpty()) {
                return false;
            }
            if (!world.field_72995_K) {
                for (BlockPos pos : positions) {
                    world.func_175698_g(pos);
                }
            }
            return true;
        }
        BlockPos pos = BlockPos.field_177992_a;
        if (info.has(FIXED)) {
            Vec3d lookVec = player.func_70040_Z().func_186678_a(1.5);
            pos = new BlockPos(player.field_70165_t + lookVec.field_72450_a, player.field_70163_u + 1.0, player.field_70161_v + lookVec.field_72449_c);
        } else {
            RayTraceResult result = this.rayTrace(player, 10.0);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && !world.func_175623_d(pos = result.func_178782_a().func_177972_a(result.field_178784_b)) && (result = this.rayTrace(player, 10.0, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                pos = result.func_178782_a().func_177972_a(result.field_178784_b);
            }
        }
        if (world.func_175623_d(pos)) {
            if (!world.field_72995_K) {
                IBlockState state = ModBlocks.fey_light.func_176223_P();
                if (info.has(PINK)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(0));
                }
                if (info.has(YELLOW)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(1));
                }
                if (info.has(PURPLE)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(2));
                }
                if (info.has(GREEN)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(3));
                }
                if (info.has(RED)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(4));
                }
                if (info.has(BROWN)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(5));
                }
                if (info.has(BLUE)) {
                    state = ModBlocks.fey_colored_light.func_176223_P().func_177226_a((IProperty)BlockColoredFeyLight.COLOR, (Comparable)Integer.valueOf(6));
                }
                if (info.has(DECAY)) {
                    state = ModBlocks.fey_decaying_light.func_176223_P();
                }
                world.func_175656_a(pos, state);
                if (info.has(DECAY)) {
                    world.func_175684_a(pos, state.func_177230_c(), this.nextTick());
                }
                world.func_184133_a(null, pos, SoundEvents.field_187552_ah, SoundCategory.PLAYERS, 0.25f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.box = new AxisAlignedBB((double)(-this.radius_x), (double)(-this.radius_y), (double)(-this.radius_z), (double)(this.radius_x + 1), (double)(this.radius_y + 1), (double)(this.radius_z + 1));
    }

    @Nullable
    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance) {
        return this.rayTrace(player, blockReachDistance, true);
    }

    @Nullable
    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, boolean ignore) {
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, ignore, true);
    }

    static {
        CONSUME.addConflicts(DECAY, PINK, YELLOW, FIXED, PURPLE, GREEN, RED, BROWN, BLUE);
        DECAY.addConflicts(PINK, YELLOW, PURPLE, GREEN, RED, BROWN, BLUE);
        PINK.addConflicts(YELLOW, PURPLE, GREEN, RED, BROWN, BLUE);
        YELLOW.addConflicts(PURPLE, GREEN, RED, BROWN, BLUE);
        PURPLE.addConflicts(GREEN, RED, BROWN, BLUE);
        GREEN.addConflicts(RED, BROWN, BLUE);
        RED.addConflicts(BROWN, BLUE);
        BROWN.addConflicts(BLUE);
        spellName = new ResourceLocation("roots", "spell_fey_light");
        instance = new SpellFeyLight(spellName);
        lightSet = null;
    }
}

