/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageDisarmFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellDisarm
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(350);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("moonglow_leaf", 0.425));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("wildewheet", 0.125));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 5).setDescription("radius on the X axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("radius on the Y axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 5).setDescription("radius on the Z axis within which entities are affected by the spell");
    public static Property<Float> PROP_DROP_CHANCE = new Property<Float>("drop_chance", Float.valueOf(0.35f)).setDescription("percentage chance for disarmed mobs to actually drop their weapons (default 0.35 = 35%)");
    public static Property<Float> PROP_CHANCE_INCREASE = new Property<Float>("chance_increase", Float.valueOf(0.35f)).setDescription("percentage chance to be applied when increased drop chance is active (default 0.35 = 35%)");
    public static Property<Float> PROP_ARMOR = new Property<Float>("armor_chance", Float.valueOf(0.3f)).setDescription("percent chance when armor is enabled to drop armor (percent doubled when both applied)");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 120).setDescription("duration of the poison effect when applied");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the amplifier to be applied to the poison effect");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 4).setDescription("duration that disarmed creatures should be set on fire for in seconds");
    public static Property<Float> PROP_KNOCKBACK = new Property<Float>("knockback_strength", Float.valueOf(0.5f)).setDescription("the strength of the knockback effect");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 80).setDescription("how long enemies should be weakened in place for");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the amplifier to be applied to the weakness effect");
    public static Modifier DROP_CHANCE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "boost_drops"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.45)));
    public static Modifier ARMOR1 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "armor_i"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.45)));
    public static Modifier DUO = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "disarm_duumvirate"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.45)));
    public static Modifier ARMOR2 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "armor_ii"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.45)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poison_hands"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.45)));
    public static Modifier FLOWERS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "flower_child"), ModifierCores.CLOUD_BERRY, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "blaze"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.275)));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "weakness"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.375)));
    public static Modifier KNOCKBACK = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "liquid_lurch"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.45)));
    public static List<EntityEquipmentSlot> HANDS;
    public static List<EntityEquipmentSlot> ARMOR;
    public static ResourceLocation spellName;
    public static SpellDisarm instance;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private int poison_duration;
    private int poison_amplifier;
    private int fire_duration;
    private int weakness_duration;
    private int weakness_amplifier;
    private float drop_chance;
    private float armor_chance;
    private float chance_increase;
    private float knockback;

    private SpellDisarm(ResourceLocation name) {
        super(name, TextFormatting.DARK_RED, 0.22745098f, 0.22745098f, 0.22745098f, 0.47843137f, 0.0f, 0.0f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_DROP_CHANCE, PROP_CHANCE_INCREASE, PROP_ARMOR, PROP_POISON_AMPLIFIER, PROP_POISON_DURATION, PROP_FIRE_DURATION, PROP_KNOCKBACK, PROP_WEAKNESS_AMPLIFIER, PROP_WEAKNESS_DURATION);
        this.acceptModifiers(DROP_CHANCE, ARMOR1, DUO, ARMOR2, POISON, FLOWERS, FIRE, WEAKNESS, KNOCKBACK);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(ModItems.moonglow_leaf), new OreIngredient("gemDiamond"), new OreIngredient("bone"), new ItemStack(Item.func_150898_a((Block)Blocks.field_150479_bC)), new ItemStack(ModItems.moonglow_leaf));
        this.setCastSound(ModSounds.Spells.DISARM);
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        if (ARMOR == null) {
            ARMOR = Arrays.asList(EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET);
        }
        if (HANDS == null) {
            HANDS = Arrays.asList(EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND);
        }
        BlockPos playerPos = caster.func_180425_c();
        World world = caster.field_70170_p;
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(playerPos.func_177958_n() - this.radius_x), (double)(playerPos.func_177956_o() - this.radius_y), (double)(playerPos.func_177952_p() - this.radius_z), (double)(playerPos.func_177958_n() + this.radius_x), (double)(playerPos.func_177956_o() + this.radius_y), (double)(playerPos.func_177952_p() + this.radius_z)));
        entities.remove(caster);
        if (entities.isEmpty()) {
            return false;
        }
        int count = 0;
        for (EntityLivingBase entity : entities) {
            float armorChance;
            if (!EntityUtil.isHostile((Entity)entity, instance)) continue;
            boolean disarmed = false;
            for (EntityEquipmentSlot handSlot : HANDS) {
                ItemStack stack = entity.func_184582_a(handSlot);
                if (stack.func_190926_b() || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150328_O)) continue;
                disarmed = true;
                if (world.field_72995_K) continue;
                if (info.has(FLOWERS)) {
                    entity.func_184201_a(handSlot, new ItemStack(Item.func_150898_a((Block)Blocks.field_150328_O)));
                } else {
                    entity.func_184201_a(handSlot, ItemStack.field_190927_a);
                }
                if (!(Util.rand.nextFloat() < this.drop_chance + this.chance_increase)) continue;
                ItemUtil.spawnItem((World)world, (BlockPos)entity.func_180425_c(), (ItemStack)stack);
            }
            float f = armorChance = info.has(ARMOR1) ? this.armor_chance : 0.0f;
            if (info.has(ARMOR2)) {
                armorChance += this.armor_chance;
            }
            for (EntityEquipmentSlot slot : ARMOR) {
                ItemStack stack = entity.func_184582_a(slot);
                if (stack.func_190926_b()) continue;
                disarmed = true;
                if (world.field_72995_K) continue;
                entity.func_184201_a(slot, ItemStack.field_190927_a);
                if (!(Util.rand.nextFloat() < armorChance)) continue;
                ItemUtil.spawnItem((World)world, (BlockPos)entity.func_180425_c(), (ItemStack)stack);
            }
            if (!disarmed) continue;
            if (!world.field_72995_K) {
                if (info.has(POISON)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.poison_duration, this.poison_amplifier));
                }
                if (info.has(FIRE)) {
                    entity.func_70015_d(this.fire_duration);
                }
                if (info.has(WEAKNESS)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, this.weakness_duration, this.weakness_amplifier));
                }
                if (info.has(KNOCKBACK)) {
                    entity.func_70653_a((Entity)caster, this.knockback, caster.field_70165_t - entity.field_70165_t, caster.field_70161_v - entity.field_70161_v);
                }
                PacketHandler.sendToAllTracking((IMessage)new MessageDisarmFX(entity.func_180425_c().func_177958_n(), entity.func_180425_c().func_177956_o(), entity.func_180425_c().func_177952_p()), (Entity)caster);
            }
            if (info.has(DUO) && count < 2) {
                ++count;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.drop_chance = this.properties.get(PROP_DROP_CHANCE).floatValue();
        this.chance_increase = this.properties.get(PROP_CHANCE_INCREASE).floatValue();
        this.armor_chance = this.properties.get(PROP_ARMOR).floatValue();
        this.knockback = this.properties.get(PROP_KNOCKBACK).floatValue();
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
    }

    static {
        POISON.addConflict(FLOWERS);
        spellName = new ResourceLocation("roots", "spell_disarm");
        instance = new SpellDisarm(spellName);
    }
}

