/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageChrysopoeiaFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.recipe.ChrysopoeiaRecipe;
import epicsquid.roots.spell.SpellBase;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellChrysopoeia
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(0);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("infernal_bulb", 0.5));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("dewgonia", 0.5));
    public static Property.PropertyCost PROP_COST_3 = new Property.PropertyCost(new SpellBase.SpellCost("spirit_herb", 0.1));
    public static Property<Integer> PROP_INTERVAL = new Property<Integer>("interval", 20).setDescription("interval in ticks between each transmutation");
    public static ResourceLocation spellName = new ResourceLocation("roots", "spell_chrysopoeia");
    public static SpellChrysopoeia instance = new SpellChrysopoeia(spellName);
    private int interval;
    private static final Object2LongOpenHashMap<EntityPlayer> soundTimer = new Object2LongOpenHashMap();
    private static final long DELAY = 120L;

    public SpellChrysopoeia(ResourceLocation name) {
        super(name, TextFormatting.GOLD, 0.6901961f, 0.6627451f, 0.61960787f, 0.8784314f, 0.68235296f, 0.3882353f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_COST_3, PROP_INTERVAL);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("ingotIron"), new OreIngredient("ingotGold"), new OreIngredient("dustRedstone"), new ItemStack(Items.field_151064_bs), new OreIngredient("gemDiamond"));
        this.setCastSound(ModSounds.Spells.CHRYSOPOEIA);
    }

    public static boolean shouldPlaySound(EntityPlayer player) {
        long val = soundTimer.getLong((Object)player);
        if (val == -1L) {
            soundTimer.put((Object)player, (long)player.field_70173_aa);
            return true;
        }
        if ((long)player.field_70173_aa >= val + 120L || (long)player.field_70173_aa < val) {
            soundTimer.put((Object)player, (long)player.field_70173_aa);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        World world = caster.field_70170_p;
        ItemStack offHand = caster.func_184592_cb();
        if (offHand.func_190926_b()) {
            return false;
        }
        int over = 0;
        int by = 0;
        if (this.interval != 0 && ticks % this.interval != 0) {
            return false;
        }
        ChrysopoeiaRecipe recipe = ModRecipes.getChrysopoeiaRecipe(offHand);
        if (recipe == null) {
            if (!world.field_72995_K && SpellChrysopoeia.shouldPlaySound(caster)) {
                world.func_184133_a(null, caster.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.3f, 0.4f);
            }
            return false;
        }
        if (!world.field_72995_K) {
            ItemStack result;
            if (SpellChrysopoeia.shouldPlaySound(caster)) {
                world.func_184133_a(null, caster.func_180425_c(), SoundEvents.field_187772_dn, SoundCategory.PLAYERS, 0.3f, 0.4f);
            }
            if (!caster.func_191521_c(result = recipe.getCraftingResult(over))) {
                ItemUtil.spawnItem((World)world, (BlockPos)caster.func_180425_c(), (ItemStack)result);
            }
            ItemStack handResult = recipe.process(caster, offHand, over, by);
            caster.func_184611_a(EnumHand.OFF_HAND, handResult);
            MessageChrysopoeiaFX message = new MessageChrysopoeiaFX(caster);
            PacketHandler.sendToAllTracking((IMessage)message, (Entity)caster);
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.interval = this.properties.get(PROP_INTERVAL);
    }

    static {
        soundTimer.defaultReturnValue(-1L);
    }
}

