/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class FlowerRecipe {
    private final IBlockState flower;
    private final ResourceLocation registryName;
    private final int meta;
    private final Block block;
    private final ItemStack stack;
    private final List<Ingredient> allowedSoils;

    public FlowerRecipe(ResourceLocation name, IBlockState flower, List<Ingredient> allowedSoils) {
        this.flower = flower;
        this.registryName = name;
        this.block = flower.func_177230_c();
        this.meta = this.block.func_176201_c(flower);
        this.stack = new ItemStack(this.block, 1, this.meta);
        this.allowedSoils = allowedSoils;
    }

    public FlowerRecipe(ResourceLocation name, IBlockState flower) {
        this.flower = flower;
        this.registryName = name;
        this.block = flower.func_177230_c();
        this.meta = this.block.func_176201_c(flower);
        this.stack = new ItemStack(this.block, 1, this.meta);
        this.allowedSoils = Collections.emptyList();
    }

    public FlowerRecipe(ResourceLocation name, int meta, Block block) {
        this.registryName = name;
        this.meta = meta;
        this.flower = block.func_176203_a(this.meta);
        this.block = block;
        this.stack = new ItemStack(this.block, 1, this.meta);
        this.allowedSoils = Collections.emptyList();
    }

    public FlowerRecipe(ResourceLocation name, int meta, Block block, List<Ingredient> allowedSoils) {
        this.registryName = name;
        this.meta = meta;
        this.flower = block.func_176203_a(this.meta);
        this.block = block;
        this.stack = new ItemStack(this.block, 1, this.meta);
        this.allowedSoils = allowedSoils;
    }

    public ItemStack getStack() {
        return this.stack.func_77946_l();
    }

    public boolean matches(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        return this.matches(block, meta);
    }

    public boolean matches(Block block, int meta) {
        return this.block == block && this.meta == meta;
    }

    @Nullable
    public IBlockState getFlower() {
        return this.flower;
    }

    public List<Ingredient> getAllowedSoils() {
        return this.allowedSoils;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

