/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import java.util.Objects;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BarkRecipe {
    private final ResourceLocation name;
    private final ItemStack blockStack;
    private final ItemStack item;
    private final BlockPlanks.EnumType type;

    public BarkRecipe(ResourceLocation name, ItemStack result, ItemStack blockStack) {
        this.blockStack = blockStack;
        this.item = result;
        this.type = null;
        this.name = name;
    }

    public BarkRecipe(ResourceLocation name, ItemStack result, BlockPlanks.EnumType type) {
        this.item = result;
        this.type = type;
        this.name = name;
        this.blockStack = null;
    }

    public ItemStack getBlockStack() {
        if (this.blockStack == null) {
            if (this.type == BlockPlanks.EnumType.ACACIA || this.type == BlockPlanks.EnumType.DARK_OAK) {
                return new ItemStack(Blocks.field_150363_s, 1, this.type.func_176839_a() - 4);
            }
            return new ItemStack(Blocks.field_150364_r, 1, Objects.requireNonNull(this.type).func_176839_a());
        }
        return this.blockStack;
    }

    public ItemStack getBarkStack(int count) {
        ItemStack copy = this.item.func_77946_l();
        copy.func_190920_e(copy.func_190916_E() + count);
        return copy;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public BlockPlanks.EnumType getType() {
        return this.type;
    }

    public ResourceLocation getName() {
        return this.name;
    }
}

