/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.network.fx.ModifierPacket;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellStormCloud;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageStormCloudStormFX
extends ModifierPacket
implements IMessage {
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;
    private static final float[] color1 = new float[]{0.30588236f, 0.7411765f, 0.7490196f, 0.75f};
    private static final float[] color2 = new float[]{0.07058824f, 0.3529412f, 0.5411765f, 0.75f};
    private static final float[] color3 = new float[]{0.41960785f, 0.9882353f, 0.011764706f, 0.75f};
    private static final float[] color4 = new float[]{0.16470589f, 0.7411765f, 0.3647059f, 0.75f};

    public MessageStormCloudStormFX() {
    }

    public MessageStormCloudStormFX(Entity entity, ModifierSnapshot modifiers) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, modifiers);
    }

    public MessageStormCloudStormFX(double x, double y, double z, ModifierSnapshot modifiers) {
        super(modifiers);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageStormCloudStormFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageStormCloudStormFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            for (float i = 0.0f; i < 360.0f; i += (float)Util.rand.nextInt(50)) {
                double r = Math.toRadians(i);
                float x = (float)message.posX + (0.75f + Util.rand.nextFloat() - 0.5f) * (float)Math.sin(r);
                float y = (float)message.posY + 0.7f + 1.5f;
                float z = (float)message.posZ + (0.75f + Util.rand.nextFloat() - 0.5f) * (float)Math.cos(r);
                float vx = 0.0625f * (float)Math.cos(r);
                float vz = 0.025f * (float)Math.sin(r);
                if (Util.rand.nextBoolean()) {
                    vx *= -1.0f;
                    vz *= -1.0f;
                }
                float[] color = color1;
                if (Util.rand.nextBoolean()) {
                    color = color2;
                }
                if (message.hasRand(SpellStormCloud.POISON, 4)) {
                    color = Util.rand.nextBoolean() ? color3 : color4;
                }
                ParticleUtil.spawnParticleSmoke((World)world, x, y, z, vx, 0.0f, vz, color, 3.0f + Util.rand.nextFloat() * 4.0f, 80, false);
            }
        }
    }
}

