/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellShatter;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageShatterBurstFX
implements IMessage {
    private double srcX = 0.0;
    private double srcY = 0.0;
    private double srcZ = 0.0;
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;

    public MessageShatterBurstFX() {
    }

    public MessageShatterBurstFX(double sx, double sy, double sz, double x, double y, double z) {
        this.srcX = sx;
        this.srcY = sy;
        this.srcZ = sz;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.srcX = buf.readDouble();
        this.srcY = buf.readDouble();
        this.srcZ = buf.readDouble();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.srcX);
        buf.writeDouble(this.srcY);
        buf.writeDouble(this.srcZ);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageShatterBurstFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageShatterBurstFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            float scale = 40.0f;
            for (float i = 0.0f; i < scale; i += 1.0f) {
                double x = (double)(1.0f - i / scale) * message.srcX + (double)(i / scale) * message.posX;
                double y = (double)(1.0f - i / scale) * message.srcY + (double)(i / scale) * message.posY;
                double z = (double)(1.0f - i / scale) * message.srcZ + (double)(i / scale) * message.posZ;
                if (Util.rand.nextBoolean()) {
                    ParticleUtil.spawnParticleGlow((World)world, (float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, SpellShatter.instance.getFirstColours(0.25f * (i / scale)), 2.5f, 24);
                    continue;
                }
                ParticleUtil.spawnParticleGlow((World)world, (float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, SpellShatter.instance.getSecondColours(0.25f * (i / scale)), 2.5f, 24);
            }
            for (int k = 0; k < 20; ++k) {
                if (Util.rand.nextBoolean()) {
                    ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.25f * (Util.rand.nextFloat() - 0.5f), 0.25f * (Util.rand.nextFloat() - 0.5f), 0.25f * (Util.rand.nextFloat() - 0.5f), SpellShatter.instance.getFirstColours(0.25f), 5.0f, 12);
                    continue;
                }
                ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.25f * (Util.rand.nextFloat() - 0.5f), 0.25f * (Util.rand.nextFloat() - 0.5f), 0.25f * (Util.rand.nextFloat() - 0.5f), SpellShatter.instance.getSecondColours(0.25f), 5.0f, 12);
            }
        }
    }
}

