/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.roots.modifiers.instance.staff.ISnapshot;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.network.fx.ModifierPacket;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellPetalShell;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePetalShellRingFX
extends ModifierPacket
implements IMessage {
    private int ticksExisted;
    private int amplifier;
    private double posX;
    private double posY;
    private double posZ;

    public MessagePetalShellRingFX() {
    }

    public MessagePetalShellRingFX(int ticks, double posX, double posY, double posZ, int amplifier, ISnapshot snapshot) {
        super(snapshot);
        this.ticksExisted = ticks;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.amplifier = amplifier;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.ticksExisted = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.amplifier = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.ticksExisted);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.amplifier);
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessagePetalShellRingFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessagePetalShellRingFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            int count = message.amplifier;
            int shells = SpellPetalShell.instance.maxShells - 1;
            if (message.has(SpellPetalShell.CHARGES)) {
                shells += SpellPetalShell.instance.extraShells;
            }
            float radius = 0.8f;
            float height = 1.0f;
            float anglePerShell = (float)(Math.PI * 2 / (double)count);
            float angleOffset = (float)Math.toRadians(message.ticksExisted % 360);
            for (int i = 0; i <= shells; ++i) {
                float tx = (float)message.posX + radius * (float)Math.sin(angleOffset + (float)i * anglePerShell);
                float tz = (float)message.posZ + radius * (float)Math.cos(angleOffset + (float)i * anglePerShell);
                float ty = (float)message.posY + height;
                ParticleUtil.spawnParticlePetal((World)world, tx, ty, tz, 0.0f, 0.0f, 0.0f, message.has(SpellPetalShell.COLOUR) ? SpellPetalShell.mossFirst : SpellPetalShell.instance.getFirstColours(), 3.5f, 15);
                if (--count <= 0) break;
            }
        }
    }
}

