/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers;

import epicsquid.roots.api.Herb;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.IModifierCost;
import epicsquid.roots.modifiers.IModifierList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.types.IRegistryItem;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;

public interface IModifier
extends IRegistryItem {
    public boolean isDisabled();

    public String getTranslationKey();

    public String getFormatting();

    public ItemStack getStack();

    public IModifierCore getCore();

    public Map<CostType, IModifierCost> getCosts();

    public Set<IModifier> getConflicts();

    public String getIdentifier();

    public List<Property<SpellBase.ModifierCost>> asProperties();

    default public Supplier<IModifier> supply() {
        return () -> this;
    }

    default public void addConflict(IModifier supplier) {
        this.addConflict(supplier, true);
    }

    default public void addConflict(IModifier supplier, boolean reverse) {
        throw new IllegalStateException(this.getClass().toString() + " does not support addConflict.");
    }

    default public boolean conflicts(IModifier modifier) {
        for (IModifier mod : this.getConflicts()) {
            if (!mod.getModifier().equals(modifier.getModifier())) continue;
            return true;
        }
        return false;
    }

    default public <T extends IModifier, V extends NBTBase> boolean isConflicting(IModifierList<T, V> modifiers) {
        for (IModifier modifier : modifiers.getModifiers()) {
            if (!this.conflicts(modifier)) continue;
            return true;
        }
        return false;
    }

    default public IModifier getModifier() {
        return this;
    }

    public Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> var1, CostType var2);

    default public Object2DoubleOpenHashMap<Herb> apply(SpellBase spell, CostType phase) {
        return this.apply(spell.getCosts(), phase);
    }

    default public Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> costs) {
        for (CostType type : CostType.values()) {
            costs = this.apply(costs, type);
        }
        return costs;
    }

    default public Object2DoubleOpenHashMap<Herb> apply(SpellBase spell) {
        return this.apply(spell.getCosts());
    }
}

