/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.recipe.SpiritDrops;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUndeadDrop
extends ItemBase {
    private DropType type;

    public ItemUndeadDrop(@Nonnull String name, DropType type) {
        super(name);
        this.type = type;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (this.type) {
            default: {
                return EnumRarity.UNCOMMON;
            }
            case RELIQUARY: 
        }
        return EnumRarity.RARE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            ItemStack result;
            ItemStack itemStack = result = this.type == DropType.POUCH ? SpiritDrops.getRandomPouch() : SpiritDrops.getRandomReliquary();
            if (!playerIn.func_191521_c(result)) {
                ItemUtil.spawnItem((World)worldIn, (BlockPos)playerIn.func_180425_c(), (ItemStack)result);
            }
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("");
        switch (this.type) {
            default: {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"roots.spirit_pouch.tooltip", (Object[])new Object[0]));
                break;
            }
            case RELIQUARY: {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"roots.reliquary.tooltip", (Object[])new Object[0]));
            }
        }
    }

    public static enum DropType {
        RELIQUARY,
        POUCH;

    }
}

