/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.EventManager;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.info.SpellDustInfo;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.DustSpellStorage;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStaff
extends ItemBase {
    public ItemStaff(String name) {
        super(name);
        this.func_77625_d(1);
        this.field_77787_bX = true;
        this.func_77627_a(true);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        StaffSpellStorage oldCapability = StaffSpellStorage.fromStack(oldStack);
        StaffSpellStorage newCapability = StaffSpellStorage.fromStack(newStack);
        return slotChanged || oldCapability != null && newCapability != null && oldCapability.getSelectedSlot() != newCapability.getSelectedSlot();
    }

    public ItemStack nextSlot(World world, EntityPlayer player, ItemStack stack, StaffSpellStorage capability) {
        StaffSpellInfo info;
        capability.nextSlot();
        if (world.field_72995_K && (info = capability.getSelectedInfo()) != null) {
            SpellBase spell = info.getSpell();
            player.func_146105_b(new TextComponentTranslation("roots.info.staff.slot_and_spell", new Object[]{capability.getSelectedSlot(), spell == null ? "none" : new TextComponentTranslation("roots.spell." + spell.getName() + ".name", new Object[0]).func_150255_a(new Style().func_150238_a(spell.getTextColor()).func_150227_a(Boolean.valueOf(true)))}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)), true);
        }
        return stack;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        StaffSpellInfo info;
        ItemStack stack = player.func_184586_b(hand);
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (player.func_70093_af() && capability != null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.nextSlot(world, player, stack, capability));
        }
        if (capability != null && !capability.onCooldown() && (info = capability.getSelectedInfo()) != null) {
            SpellBase spell = info.getSpell();
            if (spell != null && spell.getCastType() != SpellBase.EnumCastType.CONTINUOUS) {
                if (spell.getCastType() == SpellBase.EnumCastType.INSTANTANEOUS) {
                    SpellBase.CastResult result;
                    if (spell.costsMet(player, info.getModifiers()) && (result = spell.cast(player, info, 0)).isSuccess() && !player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
                        spell.enactCosts(player, info.getModifiers());
                        capability.setCooldown(result.modifyCooldown(info.cooldownTotal()) + player.field_70170_p.func_82737_E());
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (spell != null && spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (player instanceof EntityPlayer && capability != null) {
            SpellBase.CastResult result;
            SpellBase spell;
            StaffSpellInfo info = capability.getSelectedInfo();
            SpellBase spellBase = spell = info == null ? null : info.getSpell();
            if (spell != null && spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS && spell.costsMet((EntityPlayer)player, info.getModifiers()) && (result = spell.cast((EntityPlayer)player, info, count)).isSuccess() && !player.field_70170_p.field_72995_K) {
                spell.enactTickCosts((EntityPlayer)player, info.getModifiers());
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability == null) {
            return;
        }
        StaffSpellInfo info = capability.getSelectedInfo();
        SpellBase spell = info == null ? null : info.getSpell();
        EntityPlayer player = (EntityPlayer)entity;
        if (spell != null && spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS && !player.func_184812_l_()) {
            info.use(player.field_70170_p.func_82737_E());
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability != null) {
            capability.tick(entity.field_70170_p.func_82737_E());
        }
    }

    public static void createData(ItemStack stack, DustSpellStorage dustCapability) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability != null) {
            capability.addSpell(((SpellDustInfo)Objects.requireNonNull(dustCapability.getSelectedInfo())).toStaff());
            if (capability.getSelectedSlot() == 0) {
                capability.setSelectedSlot(1);
            }
        }
    }

    public static void clearData(ItemStack stack) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability != null) {
            capability.clearSelectedSlot();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability == null) {
            return;
        }
        tooltip.add(I18n.func_135052_a((String)"roots.tooltip.staff.selected", (Object[])new Object[0]) + capability.getSelectedSlot());
        StaffSpellInfo info = capability.getSelectedInfo();
        if (info != null) {
            SpellBase spell = info.getSpell();
            if (spell != null) {
                tooltip.add("");
                spell.addToolTip(tooltip, info.getModifiers());
            }
        } else {
            tooltip.add("");
            tooltip.add("No spell.");
        }
        if (GuiScreen.func_146272_n()) {
            tooltip.add("");
            for (int i = StaffSpellStorage.MIN_SPELL_SLOT; i <= StaffSpellStorage.MAX_SPELL_SLOT; ++i) {
                info = capability.getSpellInSlot(i);
                if (info == null) continue;
                SpellBase other = info.getSpell();
                if (other == null) {
                    tooltip.add("" + i + ": No spell.");
                    continue;
                }
                tooltip.add("" + i + ": " + other.getTextColor() + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + other.getName() + ".name"), (Object[])new Object[0]));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        return capability != null && capability.onCooldown();
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability == null) {
            return Util.intColor((int)255, (int)255, (int)255);
        }
        StaffSpellInfo info = capability.getSelectedInfo();
        if (info == null) {
            return Util.intColor((int)255, (int)255, (int)255);
        }
        SpellBase spell = info.getSpell();
        if (spell != null) {
            double factor = 0.5 * (Math.sin(6.0 * Math.toRadians((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak())) + 1.0);
            return Util.intColor((int)((int)(255.0 * ((double)spell.getRed1() * factor + (double)spell.getRed2() * (1.0 - factor)))), (int)((int)(255.0 * ((double)spell.getGreen1() * factor + (double)spell.getGreen2() * (1.0 - factor)))), (int)((int)(255.0 * ((double)spell.getBlue1() * factor + (double)spell.getBlue2() * (1.0 - factor)))));
        }
        return Util.intColor((int)255, (int)255, (int)255);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability == null) {
            return 0.0;
        }
        return (double)capability.getCooldownLeft() / (double)capability.getCooldown();
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        SpellBase spell;
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability == null) {
            return EnumAction.NONE;
        }
        StaffSpellInfo info = capability.getSelectedInfo();
        if (info != null && (spell = info.getSpell()) != null) {
            if (spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS) {
                return EnumAction.BOW;
            }
            return EnumAction.NONE;
        }
        return EnumAction.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName().toString()), new ModelResourceLocation(this.getRegistryName().toString() + "_1")});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            ResourceLocation baseName = this.getRegistryName();
            StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
            if (capability != null && capability.hasSpellInSlot()) {
                return new ModelResourceLocation(baseName.toString() + "_1");
            }
            return new ModelResourceLocation(baseName.toString());
        });
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
        if (capability == null) {
            return displayName;
        }
        String additional = capability.formatSelectedSpell();
        if (additional != null) {
            return displayName + " " + additional;
        }
        return displayName;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == this.func_77640_w()) {
            subItems.add((Object)new ItemStack((Item)this));
            for (SpellBase entry : SpellRegistry.spellRegistry.values()) {
                if (entry.isDisabled()) continue;
                subItems.add((Object)entry.getStaff());
            }
        }
    }

    public static class StaffColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            StaffSpellStorage capability = StaffSpellStorage.fromStack(stack);
            if (capability != null && capability.hasSpellInSlot() && stack.func_77973_b() instanceof ItemStaff) {
                StaffSpellInfo info = capability.getSelectedInfo();
                if (info == null) {
                    return Util.intColor((int)255, (int)255, (int)255);
                }
                SpellBase spell = info.getSpell();
                if (spell != null) {
                    if (tintIndex == 1) {
                        int r = (int)(255.0f * spell.getRed1());
                        int g = (int)(255.0f * spell.getGreen1());
                        int b = (int)(255.0f * spell.getBlue1());
                        return (r << 16) + (g << 8) + b;
                    }
                    if (tintIndex == 2) {
                        int r = (int)(255.0f * spell.getRed2());
                        int g = (int)(255.0f * spell.getGreen2());
                        int b = (int)(255.0f * spell.getBlue2());
                        return (r << 16) + (g << 8) + b;
                    }
                }
                return Util.intColor((int)255, (int)255, (int)255);
            }
            return Util.intColor((int)255, (int)255, (int)255);
        }
    }
}

