/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.IModifierCost;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.spell.SpellBase;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellModifier
extends ItemBase {
    public ItemSpellModifier(String name) {
        super(name);
        this.field_77787_bX = true;
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == this.func_77640_w()) {
            for (Modifier modifier : ModifierRegistry.getModifiers()) {
                if (ModifierRegistry.isDisabled(modifier)) continue;
                ItemStack mod = new ItemStack((Item)this);
                NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)mod);
                tag.func_74778_a("modifier", modifier.getRegistryName().toString());
                subItems.add((Object)mod);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)stack);
        if (tag.func_74764_b("modifier")) {
            ResourceLocation mod = new ResourceLocation(tag.func_74779_i("modifier"));
            Modifier modifier = ModifierRegistry.get(mod);
            if (modifier == null) {
                return "Unknown";
            }
            return I18n.func_74838_a((String)modifier.getTranslationKey());
        }
        return "Unknown";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)stack);
        if (tag.func_74764_b("modifier")) {
            ResourceLocation mod = new ResourceLocation(tag.func_74779_i("modifier"));
            Modifier modifier = ModifierRegistry.get(mod);
            if (modifier == null) {
                return;
            }
            SpellBase spell = ModifierRegistry.getSpellFromModifier(modifier);
            if (spell == null) {
                return;
            }
            tooltip.add("");
            tooltip.add(modifier.getFormatting() + net.minecraft.client.resources.I18n.func_135052_a((String)modifier.getTranslationKey(), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.tooltip.modifier.spell_name", (Object[])new Object[]{net.minecraft.client.resources.I18n.func_135052_a((String)(spell.getTranslationKey() + ".name"), (Object[])new Object[0])}));
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.tooltip.modifier.herb_name", (Object[])new Object[]{net.minecraft.client.resources.I18n.func_135052_a((String)(modifier.getCore().getStack().func_77977_a() + ".name"), (Object[])new Object[0])}));
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)(modifier.getTranslationKey() + ".desc"), (Object[])new Object[0]));
            if (!modifier.getConflicts().isEmpty()) {
                StringJoiner conflict = new StringJoiner(", ");
                for (IModifier m : modifier.getConflicts()) {
                    conflict.add(m.getFormatting() + net.minecraft.client.resources.I18n.func_135052_a((String)m.getTranslationKey(), (Object[])new Object[0]) + TextFormatting.RESET);
                }
                tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.tooltip.modifier.conflicts", (Object[])new Object[]{conflict.toString()}));
            }
            tooltip.add(TextFormatting.BOLD + net.minecraft.client.resources.I18n.func_135052_a((String)"roots.tooltip.modifier.costs", (Object[])new Object[0]) + TextFormatting.RESET);
            for (IModifierCost cost : modifier.getCosts().values()) {
                switch (cost.getCost()) {
                    case NO_COST: {
                        break;
                    }
                    case ADDITIONAL_COST: {
                        if (cost.getHerb() == null) {
                            throw new NullPointerException("Additional herb modifier cost type but no herb specified.");
                        }
                        tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.additional_cost", (Object[])new Object[]{net.minecraft.client.resources.I18n.func_135052_a((String)(cost.getHerb().getStack().func_77977_a() + ".name"), (Object[])new Object[0]), String.format("%.4f", cost.getValue())}));
                        break;
                    }
                    case ALL_COST_MULTIPLIER: {
                        if (cost.getValue() < 0.0) {
                            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.decreased_cost", (Object[])new Object[]{Math.floor(cost.getValue() * 100.0) + "%"}));
                            break;
                        }
                        tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.increased_cost", (Object[])new Object[]{Math.floor(cost.getValue() * 100.0) + "%"}));
                        break;
                    }
                    case SPECIFIC_COST_ADJUSTMENT: {
                        if (cost.getValue() < 0.0) {
                            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.specific_decreased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                            break;
                        }
                        tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.specific_increased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                        break;
                    }
                    case SPECIFIC_COST_MULTIPLIER: {
                        if (cost.getValue() < 0.0) {
                            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.specific_decreased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                            break;
                        }
                        tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"roots.guide.modifier.specific_increased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                        break;
                    }
                }
            }
        }
    }
}

