/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.info.AbstractSpellInfo;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.spell.info.SpellDustInfo;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.DustSpellStorage;
import epicsquid.roots.spell.info.storage.LibrarySpellStorage;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellIcon
extends ItemBase {
    private static Map<SpellBase, ModelResourceLocation> spellMap = new HashMap<SpellBase, ModelResourceLocation>();

    public ItemSpellIcon(String name) {
        super(name);
        this.field_77787_bX = true;
        this.func_77627_a(true);
    }

    public void initModel() {
        SpellRegistry.getSpells().forEach(o -> {
            String path = o.getRegistryName().func_110623_a();
            path = path.replace("spell_", "");
            spellMap.put((SpellBase)o, new ModelResourceLocation(new ResourceLocation("roots", path), "inventory"));
        });
        ModelBakery.registerItemVariants((Item)ModItems.spell_icon, (ResourceLocation[])((ResourceLocation[])spellMap.values().toArray(new ModelResourceLocation[0])));
        ModelResourceLocation res = new ModelResourceLocation(new ResourceLocation("roots", "spell_icon"), "inventory");
        ModelLoader.setCustomMeshDefinition((Item)ModItems.spell_icon, stack -> {
            SpellBase spell;
            AbstractSpellInfo info;
            StaffSpellStorage storage1 = StaffSpellStorage.fromStack(stack);
            DustSpellStorage storage2 = DustSpellStorage.fromStack(stack);
            if (storage1 != null && (info = storage1.getSelectedInfo()) != null && (spell = info.getSpell()) != null) {
                return spellMap.get(spell);
            }
            if (storage2 != null && (info = (SpellDustInfo)storage2.getSelectedInfo()) != null && (spell = info.getSpell()) != null) {
                return spellMap.get(spell);
            }
            return res;
        });
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == this.func_77640_w()) {
            for (SpellBase entry : SpellRegistry.spellRegistry.values()) {
                subItems.add((Object)entry.getIcon());
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        SpellBase spell;
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)stack);
        if (tag.func_74764_b("staff") && tag.func_74767_n("staff")) {
            SpellBase spell2;
            StaffSpellStorage storage = StaffSpellStorage.fromStack(stack);
            if (storage == null) {
                return "Unknown";
            }
            StaffSpellInfo info = storage.getSelectedInfo();
            SpellBase spellBase = spell2 = info == null ? null : info.getSpell();
            if (spell2 == null) {
                return "Unknown";
            }
            return I18n.func_74838_a((String)(spell2.getTranslationKey() + ".name")).trim();
        }
        if (tag.func_74764_b("library") && tag.func_74767_n("library")) {
            SpellBase spell3;
            LibrarySpellStorage storage = LibrarySpellStorage.fromStack(stack);
            if (storage == null) {
                return "Unknown";
            }
            LibrarySpellInfo info = (LibrarySpellInfo)storage.getSelectedInfo();
            SpellBase spellBase = spell3 = info == null ? null : info.getSpell();
            if (spell3 == null) {
                return "Unknown";
            }
            return I18n.func_74838_a((String)(spell3.getTranslationKey() + ".name")).trim();
        }
        DustSpellStorage storage = DustSpellStorage.fromStack(stack);
        if (storage == null) {
            return "Unknown";
        }
        SpellDustInfo info = (SpellDustInfo)storage.getSelectedInfo();
        SpellBase spellBase = spell = info == null ? null : info.getSpell();
        if (spell == null) {
            return "Unknown";
        }
        return I18n.func_74838_a((String)(spell.getTranslationKey() + ".name")).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)stack);
        if (tag.func_74764_b("staff") && tag.func_74767_n("staff")) {
            SpellBase spell;
            StaffSpellStorage storage = StaffSpellStorage.fromStack(stack);
            if (storage == null) {
                return;
            }
            StaffSpellInfo info = storage.getSelectedInfo();
            SpellBase spellBase = spell = info == null ? null : info.getSpell();
            if (spell == null) {
                return;
            }
            spell.addToolTip(tooltip, info.getModifiers());
        } else if (tag.func_74764_b("library") && tag.func_74767_n("library")) {
            SpellBase spell;
            LibrarySpellStorage storage = LibrarySpellStorage.fromStack(stack);
            if (storage == null) {
                return;
            }
            LibrarySpellInfo info = (LibrarySpellInfo)storage.getSelectedInfo();
            SpellBase spellBase = spell = info == null ? null : info.getSpell();
            if (spell == null) {
                return;
            }
            spell.addToolTip(tooltip, info.getModifiers());
        } else {
            SpellBase spell;
            DustSpellStorage storage = DustSpellStorage.fromStack(stack);
            if (storage == null) {
                return;
            }
            SpellDustInfo info = (SpellDustInfo)storage.getSelectedInfo();
            SpellBase spellBase = spell = info == null ? null : info.getSpell();
            if (spell == null) {
                return;
            }
            spell.addToolTip(tooltip, (StaffModifierInstanceList)null);
        }
    }
}

