/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.tileentity.TileEntityPyre;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFireStarter
extends ItemBase {
    public ItemFireStarter(@Nonnull String name) {
        super(name);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 200;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        EntityPlayer player;
        RayTraceResult result;
        if (!world.field_72995_K && entity instanceof EntityPlayer && (result = this.func_77621_a(entity.field_70170_p, player = (EntityPlayer)entity, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            EnumFacing facing = result.field_178784_b;
            BlockPos hit = result.func_178782_a();
            IBlockState hitState = world.func_180495_p(hit);
            boolean pyre = hitState.func_177230_c() == ModBlocks.pyre || hitState.func_177230_c() == ModBlocks.reinforced_pyre;
            if (!player.func_175151_a(hit = hit.func_177972_a(facing), facing, stack)) {
                return stack;
            }
            boolean used = false;
            if (!pyre && world.func_175623_d(hit)) {
                world.func_184133_a(player, hit, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                world.func_180501_a(hit, Blocks.field_150480_ab.func_176223_P(), 11);
                used = true;
            } else {
                TileEntity te = world.func_175625_s(result.func_178782_a());
                if (te instanceof TileEntityPyre) {
                    TileEntityPyre pyreTe = (TileEntityPyre)te;
                    pyreTe.startRitual(player.func_110124_au(), false);
                    pyreTe.setLastPlayerId(player.func_110124_au());
                    used = true;
                }
            }
            if (used && !player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return stack;
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return GeneralConfig.FireStarterTicks;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        EntityPlayer player;
        RayTraceResult result;
        if (entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && (result = this.func_77621_a(entity.field_70170_p, player = (EntityPlayer)entity, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK && count % 3 == 0) {
            for (int i = 0; i < 2 + player.field_70146_Z.nextInt(3); ++i) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 0.0, 0.05, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("");
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"roots.fire_starter.tooltip", (Object[])new Object[0]));
    }
}

