/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei.spell;

import epicsquid.roots.spell.SpellBase;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.awt.Color;
import java.util.ArrayList;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class SpellCostWrapper
implements IRecipeWrapper {
    public final SpellBase recipe;

    public SpellCostWrapper(SpellBase recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> costs = new ArrayList<ItemStack>(this.recipe.getCostItems());
        costs.add(this.recipe.getResult());
        costs.add(this.recipe.getIcon());
        ingredients.setInputs(VanillaTypes.ITEM, costs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int row = 0;
        String spell_name = I18n.func_135052_a((String)("roots.spell." + this.recipe.getName() + ".name"), (Object[])new Object[0]);
        String name = this.recipe.getTextColor() + "" + TextFormatting.BOLD + spell_name + TextFormatting.RESET;
        int x = (110 - minecraft.field_71466_p.func_78256_a(spell_name)) / 2;
        minecraft.field_71466_p.func_78276_b(name, x, 3, Color.BLACK.getRGB());
        DoubleIterator doubleIterator = this.recipe.getCosts().values().iterator();
        while (doubleIterator.hasNext()) {
            double cost = (Double)doubleIterator.next();
            String c = String.format("x %.4f", cost);
            minecraft.field_71466_p.func_78276_b(c, 82, (row + 1) * 20, Color.BLACK.getRGB());
            ++row;
        }
    }
}

