/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.init;

import epicsquid.roots.Roots;
import epicsquid.roots.api.Herb;
import epicsquid.roots.init.ModItems;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HerbRegistry {
    public static final Map<String, Herb> registry = new HashMap<String, Herb>();
    public static final Set<Item> HERB_ITEMS = new HashSet<Item>();
    public static final Herb spirit_herb = HerbRegistry.register("spirit_herb", () -> ModItems.spirit_herb);
    public static final Herb baffle_cap = HerbRegistry.register("baffle_cap", () -> ModItems.baffle_cap);
    public static final Herb moonglow_leaf = HerbRegistry.register("moonglow_leaf", () -> ModItems.moonglow_leaf);
    public static final Herb pereskia = HerbRegistry.register("pereskia", () -> ModItems.pereskia);
    public static final Herb terra_moss = HerbRegistry.register("terra_moss", () -> ModItems.terra_moss);
    public static final Herb wildroot = HerbRegistry.register("wildroot", () -> ModItems.wildroot);
    public static final Herb wildewheet = HerbRegistry.register("wildewheet", () -> ModItems.wildewheet);
    public static final Herb infernal_bulb = HerbRegistry.register("infernal_bulb", () -> ModItems.infernal_bulb);
    public static final Herb dewgonia = HerbRegistry.register("dewgonia", () -> ModItems.dewgonia);
    public static final Herb stalicripe = HerbRegistry.register("stalicripe", () -> ModItems.stalicripe);
    public static final Herb cloud_berry = HerbRegistry.register("cloud_berry", () -> ModItems.cloud_berry);

    public static Herb register(String name, Supplier<Item> item) {
        Herb result = new Herb(item);
        result.setRegistryName(new ResourceLocation("roots", name));
        registry.put(name, result);
        return result;
    }

    @Nullable
    public static Herb getHerb(ResourceLocation res) {
        Herb result = registry.get(res.func_110623_a());
        if (result == null) {
            for (Herb herb : registry.values()) {
                if (!herb.getRegistryName().equals((Object)res)) continue;
                return herb;
            }
        }
        return result;
    }

    @Nullable
    public static Herb getHerbByName(@Nonnull String name) {
        Herb result = registry.get(name);
        if (result == null) {
            Roots.logger.warn("Herb \"" + name + "\" not found in HerbRegistry");
        }
        return result;
    }

    @Nullable
    public static Herb getHerbByItem(@Nonnull Item item) {
        if (!HerbRegistry.isHerb(item)) {
            return null;
        }
        for (Herb herb : registry.values()) {
            if (herb.getItem() != item) continue;
            return herb;
        }
        Roots.logger.warn("Herb \"" + item.getRegistryName() + "\" not found in HerbRegistry");
        return null;
    }

    public static boolean isHerb(ItemStack stack) {
        return HerbRegistry.isHerb(stack.func_77973_b());
    }

    public static boolean isHerb(@Nonnull Item item) {
        if (HERB_ITEMS.isEmpty()) {
            HERB_ITEMS.addAll(registry.values().stream().map(Herb::getItem).collect(Collectors.toSet()));
        }
        return HERB_ITEMS.contains(item);
    }
}

