/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.event;

import epicsquid.roots.config.SpellConfig;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
public class DropsHandler {
    @SubscribeEvent
    public static void onLivingDrop(LivingDropsEvent event) {
        UUID id;
        int ticks;
        EntityLivingBase dying;
        NBTTagCompound data;
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer && (data = (dying = event.getEntityLiving()).getEntityData()).func_150297_b("magnetic_ticks", 3) && ((ticks = data.func_74762_e("magnetic_ticks")) < dying.field_70173_aa || dying.field_70173_aa - ticks < 60) && data.func_186855_b("magnetic") && (id = data.func_186857_a("magnetic")) != null && id.equals(entity.func_110124_au())) {
            for (EntityItem item : event.getDrops()) {
                item.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                entity.field_70170_p.func_72838_d((Entity)item);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onExperienceDrop(LivingExperienceDropEvent event) {
        int ticks;
        EntityLivingBase dying;
        NBTTagCompound data;
        if (SpellConfig.spellFeaturesCategory.shouldMagnetismAttractXP && (data = (dying = event.getEntityLiving()).getEntityData()).func_150297_b("magnetic_ticks", 3) && ((ticks = data.func_74762_e("magnetic_ticks")) < dying.field_70173_aa || dying.field_70173_aa - ticks < 60) && data.func_186855_b("magnetic")) {
            UUID id = data.func_186857_a("magnetic");
            EntityPlayer player = event.getAttackingPlayer();
            if (id != null && id.equals(player.func_110124_au())) {
                int j;
                World world = event.getAttackingPlayer().field_70170_p;
                for (int i = event.getDroppedExperience(); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    world.func_72838_d((Entity)new EntityXPOrb(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, j));
                }
                event.setCanceled(true);
            }
        }
    }
}

