/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.modifiers.instance.staff.ISnapshot;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.network.fx.MessageChemTrailsFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellSkySoarer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityBoost
extends Entity {
    private static final Set<UUID> boostedPlayers = new HashSet<UUID>();
    private static final DataParameter<Integer> lifetime = EntityDataManager.func_187226_a(EntityBoost.class, (DataSerializer)DataSerializers.field_187192_b);
    private UUID playerId = null;
    private double origX;
    private double origY;
    private double origZ;
    private ISnapshot modifiers;
    private static Map<UUID, PlayerTracker> playerMap = new HashMap<UUID, PlayerTracker>();

    public static boolean beingBoosted(Entity player) {
        return boostedPlayers.contains(player.func_110124_au());
    }

    public EntityBoost(World worldIn) {
        this(worldIn, SpellSkySoarer.instance.lifetime);
    }

    public EntityBoost(World worldIn, int life) {
        super(worldIn);
        this.func_82142_c(true);
        this.func_70105_a(1.0f, 1.0f);
        this.func_184212_Q().func_187214_a(lifetime, (Object)life);
    }

    public void setModifiers(ISnapshot modifiers) {
        this.modifiers = modifiers;
    }

    public void setPlayer(UUID id) {
        this.playerId = id;
        Entity[] result = this.getTargets();
        if (result != null) {
            this.origX = result[1].field_70159_w;
            this.origY = result[1].field_70181_x;
            this.origZ = result[1].field_70179_y;
        }
        if (this.modifiers.has(SpellSkySoarer.NO_COLLIDE)) {
            boostedPlayers.add(id);
        }
    }

    @Nullable
    private Entity[] getTargets() {
        EntityPlayer player;
        if (this.playerId != null && (player = this.field_70170_p.func_152378_a(this.playerId)) != null) {
            Entity riding = player.func_184208_bv();
            if (riding != player) {
                return new Entity[]{player, riding};
            }
            return new Entity[]{player, player};
        }
        return null;
    }

    public boolean func_70094_T() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        this.func_184212_Q().func_187227_b(lifetime, (Object)((Integer)this.func_184212_Q().func_187225_a(lifetime) - 1));
        this.func_184212_Q().func_187217_b(lifetime);
        if ((Integer)this.func_184212_Q().func_187225_a(lifetime) <= 0) {
            Entity[] target;
            this.func_70106_y();
            boostedPlayers.remove(this.playerId);
            if (!this.field_70170_p.field_72995_K && (target = this.getTargets()) != null) {
                if (target[1] instanceof EntityBoat) {
                    target[1].field_70159_w += (double)MathHelper.func_76126_a((float)(-target[1].field_70177_z * ((float)Math.PI / 180))) * 0.25;
                    target[1].field_70181_x = 0.0;
                    target[1].field_70179_y += (double)MathHelper.func_76134_b((float)(target[1].field_70177_z * ((float)Math.PI / 180))) * 0.25;
                } else {
                    target[1].field_70159_w = this.origX;
                    target[1].field_70181_x = this.origY;
                    target[1].field_70179_y = this.origZ;
                }
                EntityPlayer player = (EntityPlayer)target[0];
                if (this.modifiers.has(SpellSkySoarer.SLOW_FALL)) {
                    player.func_70690_d(new PotionEffect((Potion)ModPotions.slow_fall, SpellSkySoarer.instance.slow_duration));
                }
                if (this.modifiers.has(SpellSkySoarer.NO_FALL_DAMAGE)) {
                    EntityBoost.markSafe(player);
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                if (this.field_70146_Z.nextBoolean()) {
                    ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t + this.field_70146_Z.nextFloat() - 0.5f, (float)this.field_70163_u + this.field_70146_Z.nextFloat() + 0.5f, (float)this.field_70161_v + this.field_70146_Z.nextFloat() - 0.5f, -0.125f * (float)this.field_70159_w, -0.125f * (float)this.field_70181_x, -0.125f * (float)this.field_70179_y, SpellSkySoarer.instance.getFirstColours(0.5f), 5.0f * this.field_70146_Z.nextFloat() + 5.0f, 40);
                    continue;
                }
                ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t + this.field_70146_Z.nextFloat() - 0.5f, (float)this.field_70163_u + this.field_70146_Z.nextFloat() + 0.5f, (float)this.field_70161_v + this.field_70146_Z.nextFloat() - 0.5f, -0.125f * (float)this.field_70159_w, -0.125f * (float)this.field_70181_x, -0.125f * (float)this.field_70179_y, SpellSkySoarer.instance.getSecondColours(0.5f), 5.0f * this.field_70146_Z.nextFloat() + 5.0f, 40);
            }
        } else {
            if (this.modifiers.has(SpellSkySoarer.CHEM_TRAILS)) {
                PacketHandler.sendToAllTracking((IMessage)new MessageChemTrailsFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y), (Entity)this);
            }
            if (this.playerId != null) {
                Entity[] result;
                float amplifier = SpellSkySoarer.instance.amplifier;
                if (this.modifiers.has(SpellSkySoarer.FASTER)) {
                    amplifier += SpellSkySoarer.instance.extended_amplifier;
                }
                if ((result = this.getTargets()) != null) {
                    EntityPlayer player = (EntityPlayer)result[0];
                    if (this.modifiers.has(SpellSkySoarer.NO_FALL_DAMAGE)) {
                        EntityBoost.markSafe(player);
                    }
                    Entity target = result[1];
                    boolean boat = target instanceof EntityBoat;
                    this.field_70165_t = player.field_70165_t;
                    this.field_70163_u = boat ? this.field_70163_u : player.field_70163_u + 1.0;
                    this.field_70161_v = player.field_70161_v;
                    Vec3d vec = player.func_70040_Z();
                    if (!this.modifiers.has(SpellSkySoarer.VERTICAL)) {
                        target.field_70159_w = vec.field_72450_a * (double)amplifier;
                        target.field_70179_y = vec.field_72449_c * (double)amplifier;
                        this.field_70159_w = vec.field_72450_a;
                        this.field_70179_y = vec.field_72449_c;
                    }
                    if (!this.modifiers.has(SpellSkySoarer.HORIZONTAL)) {
                        target.field_70181_x = boat ? target.field_70181_x : vec.field_72448_b * (double)amplifier;
                        this.field_70181_x = vec.field_72448_b;
                    }
                    target.field_70143_R = 0.0f;
                    target.field_70133_I = true;
                }
            }
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.playerId = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("id"));
        if (compound.func_74764_b("modifiers")) {
            this.modifiers = new ModifierSnapshot(compound.func_74759_k("modifiers"));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("id", (NBTBase)NBTUtil.func_186862_a((UUID)this.playerId));
        if (this.modifiers != null) {
            this.modifiers.toCompound(compound);
        }
    }

    public static Map<UUID, PlayerTracker> getPlayers() {
        return playerMap;
    }

    public static boolean safe(EntityPlayer player) {
        PlayerTracker result = playerMap.get(player.func_110124_au());
        if (result == null) {
            return false;
        }
        boolean res = result.safe(player);
        if (!res) {
            playerMap.remove(player.func_110124_au());
        }
        return res;
    }

    public static void markSafe(EntityPlayer player) {
        PlayerTracker track = playerMap.computeIfAbsent(player.func_110124_au(), PlayerTracker::new);
        track.setStart(player.field_70173_aa);
    }

    public static class PlayerTracker {
        private int start;

        public PlayerTracker(UUID id) {
        }

        public void setStart(int start) {
            this.start = start;
        }

        public boolean safe(EntityPlayer player) {
            return player.field_70173_aa - this.start < SpellSkySoarer.instance.fall_duration;
        }
    }
}

