/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.network.fx.MessageOvergrowthEffectFX;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.ritual.RitualTransmutation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualTransmutation
extends EntityRitualBase {
    private Map<BlockPos, TransmutationRecipe> recipes = new HashMap<BlockPos, TransmutationRecipe>();
    private RitualTransmutation ritual;

    public EntityRitualTransmutation(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_transmutation.getDuration() + 20));
        this.ritual = (RitualTransmutation)RitualRegistry.ritual_transmutation;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % this.ritual.interval == 0) {
            this.recipes.clear();
            List positions = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z, pos -> {
                List<TransmutationRecipe> incoming = ModRecipes.getTransmutationRecipesFor(this.field_70170_p, pos);
                if (!incoming.isEmpty()) {
                    if (incoming.size() > 1) {
                        Roots.logger.error("Multiple (" + incoming.size() + ") recipes matching block state at " + pos.toString());
                    }
                    this.recipes.put((BlockPos)pos, incoming.get(0));
                    return true;
                }
                return false;
            });
            if (positions.isEmpty()) {
                return;
            }
            BlockPos pos2 = (BlockPos)positions.remove(Util.rand.nextInt(positions.size()));
            while (!this.transmuteBlock(this.field_70170_p, pos2) && !positions.isEmpty()) {
                pos2 = (BlockPos)positions.remove(Util.rand.nextInt(positions.size()));
            }
            PacketHandler.sendToAllTracking((IMessage)new MessageOvergrowthEffectFX(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p()), (Entity)this);
        }
    }

    private boolean transmuteBlock(World world, BlockPos pos) {
        TransmutationRecipe recipe = this.recipes.get(pos);
        if (recipe == null) {
            return false;
        }
        if (recipe.getStack().func_190926_b()) {
            recipe.getState().ifPresent(s -> world.func_175656_a(pos, s));
        } else {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)recipe.getStack().func_77946_l());
        }
        return true;
    }
}

