/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.container.slots;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.container.ContainerImposer;
import epicsquid.roots.container.slots.IBooleanProvider;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.tileentity.TileEntityImposer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotImposerModifierInfo
extends Slot {
    private static IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    private final IModifierProvider info;
    private final IModifierCore core;
    private final IBooleanProvider isHidden;
    private final TileEntityImposer tile;
    private final ContainerImposer container;

    public SlotImposerModifierInfo(ContainerImposer container, IBooleanProvider isHidden, IModifierProvider info, IModifierCore core, TileEntityImposer tile, int xPosition, int yPosition) {
        super(emptyInventory, 0, xPosition, yPosition);
        this.info = info;
        this.isHidden = isHidden;
        this.core = core;
        this.tile = tile;
        this.container = container;
    }

    @Nullable
    public StaffModifierInstance get() {
        return this.info.get(this.core);
    }

    public IModifierCore getCore() {
        return this.core;
    }

    public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    public boolean func_75214_a(ItemStack stack) {
        StaffModifierInstance info = this.get();
        if (info == null) {
            return false;
        }
        if (info.isApplied()) {
            return false;
        }
        return ItemUtil.equalWithoutSize((ItemStack)stack, (ItemStack)info.getStack());
    }

    public ItemStack func_75211_c() {
        StaffModifierInstance info = this.get();
        if (info == null) {
            return ItemStack.field_190927_a;
        }
        if (info.isApplied()) {
            return info.getStack();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isDisabled() {
        StaffModifierInstance info = this.get();
        if (info == null) {
            return false;
        }
        return !info.isEnabled();
    }

    public boolean isConflicting(StaffModifierInstanceList modifiers) {
        if (modifiers == null) {
            return false;
        }
        StaffModifierInstance info = this.get();
        if (info == null) {
            return false;
        }
        return info.isConflicting(modifiers);
    }

    public List<StaffModifierInstance> getConflicts(StaffModifierInstanceList modifiers) {
        if (modifiers == null) {
            return Collections.emptyList();
        }
        StaffModifierInstance info = this.get();
        if (info == null) {
            return Collections.emptyList();
        }
        return info.getConflicts(modifiers);
    }

    public boolean isApplied() {
        StaffModifierInstance info = this.get();
        if (info == null) {
            return false;
        }
        return info.isApplied();
    }

    public boolean isApplicable() {
        StaffModifierInstance info = this.get();
        return info != null;
    }

    public boolean func_75216_d() {
        return !this.func_75211_c().func_190926_b();
    }

    public void func_75215_d(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.tile.addModifier(this.core, stack, this.container);
        }
    }

    public int func_75219_a() {
        return 1;
    }

    public int func_178170_b(ItemStack stack) {
        return 1;
    }

    public ItemStack func_75209_a(int amount) {
        return ItemStack.field_190927_a;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        return false;
    }

    public boolean func_111238_b() {
        return !this.isHidden.get();
    }

    public boolean isSameInventory(Slot other) {
        if (other instanceof SlotImposerModifierInfo) {
            return ((SlotImposerModifierInfo)other).core.equals(this.core);
        }
        return false;
    }

    @FunctionalInterface
    public static interface IModifierProvider {
        @Nullable
        public StaffModifierInstance get(IModifierCore var1);
    }
}

