/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.config;

import epicsquid.roots.spell.SpellAcidCloud;
import epicsquid.roots.spell.SpellAquaBubble;
import epicsquid.roots.spell.SpellAugment;
import epicsquid.roots.spell.SpellChrysopoeia;
import epicsquid.roots.spell.SpellDandelionWinds;
import epicsquid.roots.spell.SpellDesaturate;
import epicsquid.roots.spell.SpellDisarm;
import epicsquid.roots.spell.SpellExtension;
import epicsquid.roots.spell.SpellFeyLight;
import epicsquid.roots.spell.SpellGeas;
import epicsquid.roots.spell.SpellGrowthInfusion;
import epicsquid.roots.spell.SpellHarvest;
import epicsquid.roots.spell.SpellLifeDrain;
import epicsquid.roots.spell.SpellNaturesScythe;
import epicsquid.roots.spell.SpellPetalShell;
import epicsquid.roots.spell.SpellRadiance;
import epicsquid.roots.spell.SpellRoseThorns;
import epicsquid.roots.spell.SpellSanctuary;
import epicsquid.roots.spell.SpellSaturate;
import epicsquid.roots.spell.SpellShatter;
import epicsquid.roots.spell.SpellSkySoarer;
import epicsquid.roots.spell.SpellStormCloud;
import epicsquid.roots.spell.SpellTimeStop;
import epicsquid.roots.spell.SpellWildfire;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config.LangKey(value="config.roots.category.spells")
@Config(modid="roots", name="roots/spells", category="spells")
public class SpellConfig {
    @Config.LangKey(value="config.roots.subcategory.disable_spells")
    public static DisableSpellsCategory disableSpellsCategory = new DisableSpellsCategory();
    @Config.LangKey(value="config.roots.subcategory.spell_features")
    public static SpellFeaturesCategory spellFeaturesCategory = new SpellFeaturesCategory();
    @Config.LangKey(value="config.roots.subcategory.spell_sounds")
    public static SpellSoundsCategory spellSoundsCategory = new SpellSoundsCategory();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("roots")) {
            ConfigManager.sync((String)"roots", (Config.Type)Config.Type.INSTANCE);
            SpellWildfire.instance.setSound(SpellConfig.spellSoundsCategory.soundWildFire);
            SpellSanctuary.instance.setSound(SpellConfig.spellSoundsCategory.soundSanctuary);
            SpellDandelionWinds.instance.setSound(SpellConfig.spellSoundsCategory.soundDandelionWinds);
            SpellRoseThorns.instance.setSound(SpellConfig.spellSoundsCategory.soundRoseThorns);
            SpellShatter.instance.setSound(SpellConfig.spellSoundsCategory.soundShatter);
            SpellPetalShell.instance.setSound(SpellConfig.spellSoundsCategory.soundPetalShell);
            SpellTimeStop.instance.setSound(SpellConfig.spellSoundsCategory.soundTimeStop);
            SpellSkySoarer.instance.setSound(SpellConfig.spellSoundsCategory.soundSkySoarer);
            SpellLifeDrain.instance.setSound(SpellConfig.spellSoundsCategory.soundLifeDrain);
            SpellAcidCloud.instance.setSound(SpellConfig.spellSoundsCategory.soundAcidCloud);
            SpellGrowthInfusion.instance.setSound(SpellConfig.spellSoundsCategory.soundGrowthInfusion);
            SpellGeas.instance.setSound(SpellConfig.spellSoundsCategory.soundGeas);
            SpellRadiance.instance.setSound(SpellConfig.spellSoundsCategory.soundRadiance);
            SpellHarvest.instance.setSound(SpellConfig.spellSoundsCategory.soundHarvest);
            SpellFeyLight.instance.setSound(SpellConfig.spellSoundsCategory.soundFeyLight);
            SpellStormCloud.instance.setSound(SpellConfig.spellSoundsCategory.soundStormCloud);
            SpellSaturate.instance.setSound(SpellConfig.spellSoundsCategory.soundSaturate);
            SpellDesaturate.instance.setSound(SpellConfig.spellSoundsCategory.soundDesaturate);
            SpellChrysopoeia.instance.setSound(SpellConfig.spellSoundsCategory.soundChrysopoeia);
            SpellDisarm.instance.setSound(SpellConfig.spellSoundsCategory.soundDisarm);
            SpellNaturesScythe.instance.setSound(SpellConfig.spellSoundsCategory.soundNaturesScythe);
            SpellAquaBubble.instance.setSound(SpellConfig.spellSoundsCategory.soundAquaBubble);
            SpellAugment.instance.setSound(SpellConfig.spellSoundsCategory.soundAugment);
            SpellExtension.instance.setSound(SpellConfig.spellSoundsCategory.soundExtension);
        }
    }

    public static class SpellSoundsCategory {
        @Config.Name(value="Acid Cloud Spell")
        @Config.Comment(value={"Sounds settings for Acid Cloud Spell"})
        public SpellSound soundAcidCloud = new SpellSound();
        @Config.Name(value="Aqueous Bubble Spell")
        @Config.Comment(value={"Sounds settings for the Aqueous Bubble Spell"})
        public SpellSound soundAquaBubble = new SpellSound();
        @Config.Name(value="Augment Spell")
        @Config.Comment(value={"Sounds settings for the Augment Spell"})
        public SpellSound soundAugment = new SpellSound();
        @Config.Name(value="Chrysopoeia Spell")
        @Config.Comment(value={"Sounds settings for the Chrysopoeia Spell"})
        public SpellSound soundChrysopoeia = new SpellSound();
        @Config.Name(value="Dandelion Winds Spell")
        @Config.Comment(value={"Sounds settings for Dandelion Winds Spell"})
        public SpellSound soundDandelionWinds = new SpellSound();
        @Config.Name(value="Desaturate Spell")
        @Config.Comment(value={"Sounds settings for the Desaturate Spell"})
        public SpellSound soundDesaturate = new SpellSound();
        @Config.Name(value="Disarm Spell")
        @Config.Comment(value={"Sounds settings for Disarm Spell"})
        public SpellSound soundDisarm = new SpellSound();
        @Config.Name(value="Extension Spell")
        @Config.Comment(value={"Sounds settings for the Extension Spell"})
        public SpellSound soundExtension = new SpellSound();
        @Config.Name(value="Fey Light Spell")
        @Config.Comment(value={"Sounds settings for the Fey Light Spell"})
        public SpellSound soundFeyLight = new SpellSound();
        @Config.Name(value="Geas Spell")
        @Config.Comment(value={"Sounds settings for Geas Spell"})
        public SpellSound soundGeas = new SpellSound();
        @Config.Name(value="Growth Infusion Spell")
        @Config.Comment(value={"Sounds settings for Growth Infusion Spell"})
        public SpellSound soundGrowthInfusion = new SpellSound();
        @Config.Name(value="Harvest Spell")
        @Config.Comment(value={"Sounds settings for Harvest Spell"})
        public SpellSound soundHarvest = new SpellSound();
        @Config.Name(value="Life Drain Spell")
        @Config.Comment(value={"Sounds settings for Life Drain Spell"})
        public SpellSound soundLifeDrain = new SpellSound();
        @Config.Name(value="Nature's Scythe")
        @Config.Comment(value={"Sounds settings for Nature's Scythe Spell"})
        public SpellSound soundNaturesScythe = new SpellSound();
        @Config.Name(value="Petal Shell Spell")
        @Config.Comment(value={"Sounds settings for Petal Shell Spell"})
        public SpellSound soundPetalShell = new SpellSound();
        @Config.Name(value="Radiance Spell")
        @Config.Comment(value={"Sounds settings for Radiance Spell"})
        public SpellSound soundRadiance = new SpellSound();
        @Config.Name(value="Rose Thorns Spell")
        @Config.Comment(value={"Sounds settings for Rose Thorns Spell"})
        public SpellSound soundRoseThorns = new SpellSound();
        @Config.Name(value="Sanctuary Spell")
        @Config.Comment(value={"Sounds settings for Sanctuary Spell"})
        public SpellSound soundSanctuary = new SpellSound();
        @Config.Name(value="Saturate Spell")
        @Config.Comment(value={"Sounds settings for the Saturate Spell"})
        public SpellSound soundSaturate = new SpellSound();
        @Config.Name(value="Shatter Spell")
        @Config.Comment(value={"Sounds settings for Shatter Spell"})
        public SpellSound soundShatter = new SpellSound();
        @Config.Name(value="Sky Soarer Spell")
        @Config.Comment(value={"Sounds settings for Sky Soarer Spell"})
        public SpellSound soundSkySoarer = new SpellSound();
        @Config.Name(value="Storm Cloud Spell")
        @Config.Comment(value={"Sounds settings for the Storm Cloud Spell"})
        public SpellSound soundStormCloud = new SpellSound();
        @Config.Name(value="Time Stop Spell")
        @Config.Comment(value={"Sounds settings for Time Stop Spell"})
        public SpellSound soundTimeStop = new SpellSound();
        @Config.Name(value="Wild Fire Spell")
        @Config.Comment(value={"Sounds settings for Wild Fire Spell"})
        public SpellSound soundWildFire = new SpellSound();

        public static class SpellSound {
            @Config.Name(value="Enable sound")
            @Config.Comment(value={"Set to false to prevent the sounds for this spell from being played"})
            public boolean enabled = true;
            @Config.Name(value="Volume")
            @Config.Comment(value={"Set the volume of the sounds for this spell"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double volume = 1.0;
        }
    }

    public static class SpellFeaturesCategory {
        @Config.Name(value="Should Acid Cloud Poison Enemies")
        @Config.Comment(value={"Set to false to disable Acid Cloud's poisoning effect on enemies"})
        public boolean acidCloudPoisoningEffect = true;
        @Config.Name(value="Should Magnetism Attract Experience Orbs")
        @Config.Comment(value={"Set to true to allow the spell to attract xp orbs as well"})
        public boolean shouldMagnetismAttractXP = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Sanctuary Spell Entities Blacklist")
        @Config.Comment(value={"Entities in this list will be excluded by Sanctuary Spell when repelling entities (formatted as mod:mobname)"})
        public String[] sanctuaryEntitiesBlacklist = new String[0];
        @Config.Ignore
        public Set<ResourceLocation> resources = null;

        public Set<ResourceLocation> getSanctuaryBlacklist() {
            if (this.resources == null) {
                this.resources = Stream.of(this.sanctuaryEntitiesBlacklist).map(ResourceLocation::new).collect(Collectors.toSet());
            }
            return this.resources;
        }
    }

    public static class DisableSpellsCategory {
        @Config.Name(value="Disable Acid Cloud Spell")
        @Config.Comment(value={"Set to true to disable Acid Cloud Spell"})
        public boolean disableAcidCloud = false;
        @Config.Name(value="Disable Aqueous Bubble Spell")
        @Config.Comment(value={"Set to true to disable the Aqueous Bubble Spell"})
        public boolean disableAquaBubble = false;
        @Config.Name(value="Disable Augment Spell")
        @Config.Comment(value={"Set to true to disable the Augment Spell"})
        public boolean disableAugment = false;
        @Config.Name(value="Disable Chrysopoeia Spell")
        @Config.Comment(value={"Set to true to disable the Chrysopoeia Spell"})
        public boolean disableChrysopoeia = false;
        @Config.Name(value="Disable Dandelion Winds Spell")
        @Config.Comment(value={"Set to true to disable Dandelion Winds Spell"})
        public boolean disableDandelionWinds = false;
        @Config.Name(value="Disable Desaturate Spell")
        @Config.Comment(value={"Set to true to disable the Desaturate Spell"})
        public boolean disableDesaturate = false;
        @Config.Name(value="Disable Disarm Spell")
        @Config.Comment(value={"Set to true to disable Disarm Spell"})
        public boolean disableDisarm = false;
        @Config.Name(value="Disable Extension Spell")
        @Config.Comment(value={"Set to true to disable the Extension Spell"})
        public boolean disableExtension = false;
        @Config.Name(value="Disable Fey Light Spell")
        @Config.Comment(value={"Set to true to disable the Fey Light Spell"})
        public boolean disableFeyLight = false;
        @Config.Name(value="Disable Geas Spell")
        @Config.Comment(value={"Set to true to disable Geas Spell"})
        public boolean disableGeas = false;
        @Config.Name(value="Disable Growth Infusion Spell")
        @Config.Comment(value={"Set to true to disable Growth Infusion Spell"})
        public boolean disableGrowthInfusion = false;
        @Config.Name(value="Disable Harvest Spell")
        @Config.Comment(value={"Set to true to disable Harvest Spell"})
        public boolean disableHarvest = false;
        @Config.Name(value="Disable Life Drain Spell")
        @Config.Comment(value={"Set to true to disable Life Drain Spell"})
        public boolean disableLifeDrain = false;
        @Config.Name(value="Disable Nature's Scythe")
        @Config.Comment(value={"Set to true to disable Nature's Scythe Spell"})
        public boolean disableNaturesScythe = false;
        @Config.Name(value="Disable Petal Shell Spell")
        @Config.Comment(value={"Set to true to disable Petal Shell Spell"})
        public boolean disablePetalShell = false;
        @Config.Name(value="Disable Radiance Spell")
        @Config.Comment(value={"Set to true to disable Radiance Spell"})
        public boolean disableRadiance = false;
        @Config.Name(value="Disable Rose Thorns Spell")
        @Config.Comment(value={"Set to true to disable Rose Thorns Spell"})
        public boolean disableRoseThorns = false;
        @Config.Name(value="Disable Sanctuary Spell")
        @Config.Comment(value={"Set to true to disable Sanctuary Spell"})
        public boolean disableSanctuary = false;
        @Config.Name(value="Disable Saturate Spell")
        @Config.Comment(value={"Set to true to disable the Saturate Spell"})
        public boolean disableSaturate = false;
        @Config.Name(value="Disable Shatter Spell")
        @Config.Comment(value={"Set to true to disable Shatter Spell"})
        public boolean disableShatter = false;
        @Config.Name(value="Disable Sky Soarer Spell")
        @Config.Comment(value={"Set to true to disable Sky Soarer Spell"})
        public boolean disableSkySoarer = false;
        @Config.Name(value="Disable Storm Cloud Spell")
        @Config.Comment(value={"Set to true to disable the Storm Cloud Spell"})
        public boolean disbleStormCloud = false;
        @Config.Name(value="Disable Time Stop Spell")
        @Config.Comment(value={"Set to true to disable Time Stop Spell"})
        public boolean disableTimeStop = false;
        @Config.Name(value="Disable Wild Fire Spell")
        @Config.Comment(value={"Set to true to disable Wild Fire Spell"})
        public boolean disableWildFire = false;
    }
}

