/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import requious.gui.GaugeDirection;
import requious.util.Fill;
import requious.util.Misc;

public class SlotVisual {
    List<Part> parts = new ArrayList<Part>();
    public static ResourceLocation GUI_SLOTS = new ResourceLocation("requious", "textures/gui/assembly_slots.png");
    public static ResourceLocation GUI_GAUGES = new ResourceLocation("requious", "textures/gui/assembly_gauges.png");
    public static final SlotVisual EMPTY = new SlotVisual(1, 1);
    public static final SlotVisual ITEM_SLOT = new SlotVisual(1, 1);
    public static final SlotVisual FLUID_SLOT;
    public static final SlotVisual ENERGY_SLOT;
    public static final SlotVisual INFO_SLOT;
    public static final SlotVisual SELECTION_SLOT;
    public static final SlotVisual ARROW_RIGHT;
    public static final SlotVisual ARROW_DOWN;
    public static final SlotVisual ARROW_LEFT;
    public static final SlotVisual ARROW_UP;
    int width;
    int height;

    public SlotVisual(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addPart(ResourceLocation texture, int x, int y, Color color) {
        this.parts.add(new Part(texture, x, y, this.width, this.height, color));
    }

    public void addDirectionalPart(ResourceLocation texture, int x, int y, Color color, GaugeDirection direction, boolean inverse) {
        this.parts.add(new PartDirectional(texture, x, y, this.width, this.height, color, direction, inverse));
    }

    public void addGauge(ResourceLocation texture, int x1, int y1, int x2, int y2, Color color, GaugeDirection direction, boolean inverse) {
        this.parts.add(new Part(texture, x1, y1, this.width, this.height, Color.WHITE));
        this.parts.add(new PartDirectional(texture, x2, y2, this.width, this.height, color, direction, inverse));
    }

    public void render(Minecraft minecraft, int x, int y, int z, Fill fill) {
        for (Part part : this.parts) {
            part.render(minecraft, x, y, z, fill);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public SlotVisual copy() {
        SlotVisual copy = new SlotVisual(this.width, this.height);
        for (Part part : this.parts) {
            copy.parts.add(part.copy());
        }
        return copy;
    }

    static {
        ITEM_SLOT.addPart(GUI_SLOTS, 0, 0, Color.WHITE);
        FLUID_SLOT = new SlotVisual(1, 1);
        FLUID_SLOT.addPart(GUI_SLOTS, 1, 0, Color.WHITE);
        ENERGY_SLOT = new SlotVisual(1, 1);
        ENERGY_SLOT.addGauge(GUI_GAUGES, 0, 0, 1, 0, Color.WHITE, GaugeDirection.UP, false);
        INFO_SLOT = new SlotVisual(1, 1);
        INFO_SLOT.addPart(GUI_SLOTS, 1, 2, Color.WHITE);
        SELECTION_SLOT = new SlotVisual(1, 1);
        SELECTION_SLOT.addPart(GUI_SLOTS, 0, 0, Color.WHITE);
        SELECTION_SLOT.addDirectionalPart(GUI_SLOTS, 1, 1, Color.WHITE, GaugeDirection.UP, false);
        ARROW_RIGHT = new SlotVisual(1, 1);
        ARROW_RIGHT.addGauge(GUI_GAUGES, 0, 8, 1, 8, Color.WHITE, GaugeDirection.RIGHT, false);
        ARROW_DOWN = new SlotVisual(1, 1);
        ARROW_DOWN.addGauge(GUI_GAUGES, 2, 8, 3, 8, Color.WHITE, GaugeDirection.DOWN, false);
        ARROW_LEFT = new SlotVisual(1, 1);
        ARROW_LEFT.addGauge(GUI_GAUGES, 4, 8, 5, 8, Color.WHITE, GaugeDirection.LEFT, false);
        ARROW_UP = new SlotVisual(1, 1);
        ARROW_UP.addGauge(GUI_GAUGES, 6, 8, 7, 8, Color.WHITE, GaugeDirection.UP, false);
    }

    public static class PartDirectional
    extends Part {
        GaugeDirection direction;
        boolean inverse;

        public PartDirectional(ResourceLocation texture, int x, int y, int width, int height, Color color, GaugeDirection direction, boolean inverse) {
            super(texture, x, y, width, height, color);
            this.direction = direction;
            this.inverse = inverse;
        }

        @Override
        public void render(Minecraft minecraft, int x, int y, int z, Fill fill) {
            minecraft.func_110434_K().func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)((float)this.color.getAlpha() / 255.0f));
            int widthTotal = this.width * 18;
            int heightTotal = this.height * 18;
            int fillX = fill.getFill(widthTotal, this.inverse);
            int fillY = fill.getFill(heightTotal, this.inverse);
            int emptyX = widthTotal - fillX;
            int emptyY = heightTotal - fillY;
            int ox = 0;
            int oy = 0;
            int ow = widthTotal;
            int oh = heightTotal;
            switch (this.direction) {
                case UP: {
                    oy = emptyY;
                    oh = fillY;
                    break;
                }
                case DOWN: {
                    oh = fillY;
                    break;
                }
                case LEFT: {
                    ox = emptyX;
                    ow = fillX;
                    break;
                }
                case RIGHT: {
                    ow = fillX;
                }
            }
            Misc.drawTexturedModalRect(x + ox, y + oy, z, this.x * 18 + ox, this.y * 18 + oy, ow, oh);
        }

        @Override
        public Part copy() {
            return new PartDirectional(this.texture, this.x, this.y, this.width, this.height, this.color, this.direction, this.inverse);
        }
    }

    public static class Part {
        protected ResourceLocation texture;
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected Color color;

        public Part(ResourceLocation texture, int x, int y, int width, int height, Color color) {
            this.texture = texture;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.color = color;
        }

        public void render(Minecraft minecraft, int x, int y, int z, Fill fill) {
            minecraft.func_110434_K().func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)((float)this.color.getAlpha() / 255.0f));
            Misc.drawTexturedModalRect(x, y, z, this.x * 18, this.y * 18, this.width * 18, this.height * 18);
        }

        public Part copy() {
            return new Part(this.texture, this.x, this.y, this.width, this.height, this.color);
        }
    }
}

