/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import requious.data.AssemblyProcessor;
import requious.util.Misc;
import requious.util.color.ICustomColor;
import stanhebben.zenscript.annotations.ZenClass;

@ZenRegister
@ZenClass(value="mods.requious.Parameter")
public abstract class Parameter {
    private static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    private static double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    private static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    private static Vec3d toVector(Object value) {
        if (value instanceof Vec3d) {
            return (Vec3d)value;
        }
        return Vec3d.field_186680_a;
    }

    private static EnumFacing toFacing(Object value) {
        if (value instanceof EnumFacing) {
            return (EnumFacing)value;
        }
        return EnumFacing.UP;
    }

    private static Color toColor(Object value) {
        if (value instanceof ICustomColor) {
            return ((ICustomColor)value).get();
        }
        return Color.WHITE;
    }

    private static ItemStack toItem(Object value) {
        if (value instanceof ItemStack) {
            return (ItemStack)value;
        }
        if (value instanceof IItemStack) {
            return CraftTweakerMC.getItemStack((IItemStack)((IItemStack)value));
        }
        return ItemStack.field_190927_a;
    }

    private static FluidStack toFluid(Object value) {
        if (value instanceof FluidStack) {
            return (FluidStack)value;
        }
        return null;
    }

    public int getInteger(AssemblyProcessor assembly) {
        return Parameter.toInt(this.getValue(assembly));
    }

    public int getInteger(AssemblyProcessor assembly, float partialTicks) {
        int current = Parameter.toInt(this.getValue(assembly));
        int last = Parameter.toInt(this.getLastValue(assembly));
        return (int)MathHelper.func_151238_b((double)last, (double)current, (double)partialTicks);
    }

    public double getDouble(AssemblyProcessor assembly) {
        return Parameter.toDouble(this.getValue(assembly));
    }

    public double getDouble(AssemblyProcessor assembly, float partialTicks) {
        double current = Parameter.toDouble(this.getValue(assembly));
        double last = Parameter.toDouble(this.getLastValue(assembly));
        return MathHelper.func_151238_b((double)last, (double)current, (double)partialTicks);
    }

    public String getString(AssemblyProcessor assembly) {
        return Parameter.toString(this.getValue(assembly));
    }

    public Vec3d getVector(AssemblyProcessor assembly) {
        return Parameter.toVector(this.getValue(assembly));
    }

    public Vec3d getVector(AssemblyProcessor assembly, float partialTicks) {
        Vec3d current = Parameter.toVector(this.getValue(assembly));
        Vec3d last = Parameter.toVector(this.getLastValue(assembly));
        double x = MathHelper.func_151238_b((double)last.field_72450_a, (double)current.field_72450_a, (double)partialTicks);
        double y = MathHelper.func_151238_b((double)last.field_72448_b, (double)current.field_72448_b, (double)partialTicks);
        double z = MathHelper.func_151238_b((double)last.field_72449_c, (double)current.field_72449_c, (double)partialTicks);
        return new Vec3d(x, y, z);
    }

    public EnumFacing getFacing(AssemblyProcessor assembly) {
        return Parameter.toFacing(this.getValue(assembly));
    }

    public Color getColor(AssemblyProcessor assembly) {
        return Parameter.toColor(this.getValue(assembly));
    }

    public Color getColor(AssemblyProcessor assembly, float partialTicks) {
        Color current = Parameter.toColor(this.getValue(assembly));
        Color last = Parameter.toColor(this.getLastValue(assembly));
        return Misc.lerpColorRGB(last, current, partialTicks);
    }

    public ItemStack getItem(AssemblyProcessor assembly) {
        return Parameter.toItem(this.getValue(assembly));
    }

    public FluidStack getFluid(AssemblyProcessor assembly) {
        return Parameter.toFluid(this.getValue(assembly));
    }

    public abstract Object getValue(AssemblyProcessor var1);

    public abstract Object getLastValue(AssemblyProcessor var1);

    public abstract void stashValue(AssemblyProcessor var1);

    public static class Constant
    extends Parameter {
        Object value;

        public Constant(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue(AssemblyProcessor assembly) {
            return this.value;
        }

        @Override
        public Object getLastValue(AssemblyProcessor assembly) {
            return this.value;
        }

        @Override
        public void stashValue(AssemblyProcessor assembly) {
        }
    }

    @ZenRegister
    @ZenClass(value="mods.requious.Variable")
    public static class Variable
    extends Parameter {
        String name;

        public Variable(String name) {
            this.name = name;
        }

        @Override
        public Object getValue(AssemblyProcessor assembly) {
            return assembly.getVariable(this.name);
        }

        @Override
        public Object getLastValue(AssemblyProcessor assembly) {
            return assembly.getHistory(this.name);
        }

        @Override
        public void stashValue(AssemblyProcessor assembly) {
            assembly.stashVariable(this.name);
        }
    }
}

