/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import requious.Requious;
import requious.data.AssemblyProcessor;
import requious.particle.IParticleAnchor;
import requious.tile.TileEntityAssembly;
import requious.util.Misc;
import requious.util.Parameter;
import requious.util.RenderUtil;

public abstract class MachineVisual {
    Parameter variableActive;

    public MachineVisual(Parameter variableActive) {
        this.variableActive = variableActive;
    }

    protected boolean isActive(AssemblyProcessor assembly) {
        return this.variableActive.getDouble(assembly) > 0.0;
    }

    public void update(TileEntityAssembly tile) {
    }

    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityAssembly tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
    }

    public static class Smoke
    extends MachineVisual {
        Parameter variableStart;
        Parameter variableEnd;
        Parameter variableVelocity;
        Parameter variableLifetime;
        Parameter variableColor;
        private boolean fullBright;
        boolean global;
        Random random = new Random();

        public Smoke(Parameter variableActive, Parameter variableStart, Parameter variableEnd, Parameter variableVelocity, Parameter variableLifetime, Parameter variableColor, boolean fullBright, boolean global) {
            super(variableActive);
            this.variableStart = variableStart;
            this.variableEnd = variableEnd;
            this.variableVelocity = variableVelocity;
            this.variableLifetime = variableLifetime;
            this.variableColor = variableColor;
            this.fullBright = fullBright;
            this.global = global;
        }

        @Override
        public void update(TileEntityAssembly tile) {
            AssemblyProcessor assembly = tile.getProcessor();
            if (!this.isActive(assembly)) {
                return;
            }
            BlockPos pos = tile.func_174877_v();
            Vec3d start = this.variableStart.getVector(assembly);
            Vec3d end = this.variableEnd.getVector(assembly);
            Color color = this.variableColor.getColor(assembly);
            double x = start.field_72450_a + this.random.nextDouble() * (end.field_72450_a - start.field_72450_a);
            double y = start.field_72448_b + this.random.nextDouble() * (end.field_72448_b - start.field_72448_b);
            double z = start.field_72449_c + this.random.nextDouble() * (end.field_72449_c - start.field_72449_c);
            Vec3d offset = new Vec3d(x, y, z);
            Vec3d velocity = this.variableVelocity.getVector(assembly);
            int lifetime = this.variableLifetime.getInteger(assembly);
            lifetime = lifetime / 2 + this.random.nextInt(lifetime / 2);
            if (!this.global) {
                offset = Misc.getLocalVector(offset.func_72441_c(-0.5, -0.5, -0.5), assembly.getFacing()).func_72441_c(0.5, 0.5, 0.5);
                velocity = Misc.getLocalVector(velocity, assembly.getFacing());
            }
            Requious.PROXY.emitSmoke(tile.func_145831_w(), (double)pos.func_177958_n() + offset.field_72450_a, (double)pos.func_177956_o() + offset.field_72448_b, (double)pos.func_177952_p() + offset.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, color, lifetime, this.fullBright);
        }
    }

    public static class Flame
    extends MachineVisual {
        Parameter variableStart;
        Parameter variableEnd;
        Parameter variableVelocity;
        Parameter variableLifetime;
        Parameter variableSizeMin;
        Parameter variableSizeMax;
        Parameter variableColor;
        boolean global;
        Random random = new Random();

        public Flame(Parameter variableActive, Parameter variableStart, Parameter variableEnd, Parameter variableVelocity, Parameter variableLifetime, Parameter variableSizeMin, Parameter variableSizeMax, Parameter variableColor, boolean global) {
            super(variableActive);
            this.variableStart = variableStart;
            this.variableEnd = variableEnd;
            this.variableVelocity = variableVelocity;
            this.variableLifetime = variableLifetime;
            this.variableSizeMin = variableSizeMin;
            this.variableSizeMax = variableSizeMax;
            this.variableColor = variableColor;
            this.global = global;
        }

        @Override
        public void update(TileEntityAssembly tile) {
            AssemblyProcessor assembly = tile.getProcessor();
            if (!this.isActive(assembly)) {
                return;
            }
            BlockPos pos = tile.func_174877_v();
            Vec3d start = this.variableStart.getVector(assembly);
            Vec3d end = this.variableEnd.getVector(assembly);
            Color color = this.variableColor.getColor(assembly);
            double x = start.field_72450_a + this.random.nextDouble() * (end.field_72450_a - start.field_72450_a);
            double y = start.field_72448_b + this.random.nextDouble() * (end.field_72448_b - start.field_72448_b);
            double z = start.field_72449_c + this.random.nextDouble() * (end.field_72449_c - start.field_72449_c);
            Vec3d offset = new Vec3d(x, y, z);
            Vec3d velocity = this.variableVelocity.getVector(assembly);
            float minSize = (float)this.variableSizeMin.getDouble(assembly);
            float maxSize = (float)this.variableSizeMax.getDouble(assembly);
            int lifetime = this.variableLifetime.getInteger(assembly);
            lifetime = lifetime / 2 + this.random.nextInt(lifetime / 2);
            if (!this.global) {
                offset = Misc.getLocalVector(offset.func_72441_c(-0.5, -0.5, -0.5), assembly.getFacing()).func_72441_c(0.5, 0.5, 0.5);
                velocity = Misc.getLocalVector(velocity, assembly.getFacing());
            }
            Requious.PROXY.emitGlow(tile.func_145831_w(), IParticleAnchor.zero(), (double)pos.func_177958_n() + offset.field_72450_a, (double)pos.func_177956_o() + offset.field_72448_b, (double)pos.func_177952_p() + offset.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, color, minSize, maxSize, lifetime, 0.0f);
        }
    }

    public static class DisplayCube
    extends MachineVisual {
        Parameter variableTexture;
        Parameter variableAmount;
        Parameter variableCapacity;
        Parameter variableDirection;
        Parameter variableStart;
        Parameter variableEnd;
        boolean global;

        public DisplayCube(Parameter variableActive, Parameter variableTexture, Parameter variableAmount, Parameter variableCapacity, Parameter variableDirection, Parameter variableStart, Parameter variableEnd, boolean global) {
            super(variableActive);
            this.variableTexture = variableTexture;
            this.variableAmount = variableAmount;
            this.variableCapacity = variableCapacity;
            this.variableDirection = variableDirection;
            this.variableStart = variableStart;
            this.variableEnd = variableEnd;
            this.global = global;
        }

        @Override
        public void update(TileEntityAssembly tile) {
            AssemblyProcessor processor = tile.getProcessor();
            this.variableStart.stashValue(processor);
            this.variableEnd.stashValue(processor);
            this.variableCapacity.stashValue(processor);
        }

        @Override
        public void render(TileEntityAssembly tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
            super.render(tile, x, y, z, partialTicks, destroyStage, alpha);
            AssemblyProcessor assembly = tile.getProcessor();
            if (!this.isActive(assembly)) {
                return;
            }
            ResourceLocation texture = new ResourceLocation(this.variableTexture.getString(assembly));
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            if (texture != null) {
                EnumFacing facing = assembly.getFacing();
                int capacity = this.variableCapacity.getInteger(assembly, partialTicks);
                int amount = this.variableAmount.getInteger(assembly, partialTicks);
                int c = -1;
                double slide = (double)amount / (double)capacity;
                Vec3d start = this.variableStart.getVector(assembly, partialTicks);
                Vec3d end = this.variableEnd.getVector(assembly, partialTicks);
                if (!this.global) {
                    start = Misc.getLocalVector(start.func_72441_c(-0.5, -0.5, -0.5), facing).func_72441_c(0.5, 0.5, 0.5);
                    end = Misc.getLocalVector(end.func_72441_c(-0.5, -0.5, -0.5), facing).func_72441_c(0.5, 0.5, 0.5);
                }
                EnumFacing direction = this.variableDirection.getFacing(assembly);
                double xWest = Math.min(start.field_72450_a, end.field_72450_a);
                double xEast = Math.max(start.field_72450_a, end.field_72450_a);
                double yDown = Math.min(start.field_72448_b, end.field_72448_b);
                double yUp = Math.max(start.field_72448_b, end.field_72448_b);
                double zNorth = Math.min(start.field_72449_c, end.field_72449_c);
                double zSouth = Math.max(start.field_72449_c, end.field_72449_c);
                double width = (xEast - xWest) * slide;
                double height = (yUp - yDown) * slide;
                double depth = (zSouth - zNorth) * slide;
                switch (direction) {
                    case DOWN: {
                        yDown = yUp - height;
                        break;
                    }
                    case UP: {
                        yUp = yDown + height;
                        break;
                    }
                    case NORTH: {
                        zNorth = zSouth - depth;
                        break;
                    }
                    case SOUTH: {
                        zSouth = zNorth + depth;
                        break;
                    }
                    case WEST: {
                        xWest = xEast - width;
                        break;
                    }
                    case EAST: {
                        xEast = xWest + width;
                    }
                }
                GlStateManager.func_179129_p();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderUtil.renderTextureCuboid(texture, tile.func_174877_v(), xWest, yDown, zNorth, xEast, yUp, zSouth, c);
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static class DisplayFluid
    extends MachineVisual {
        Parameter variableFluid;
        Parameter variableCapacity;
        Parameter variableDirection;
        Parameter variableStart;
        Parameter variableEnd;
        boolean global;

        public DisplayFluid(Parameter variableActive, Parameter variableFluid, Parameter variableCapacity, Parameter variableDirection, Parameter variableStart, Parameter variableEnd, boolean global) {
            super(variableActive);
            this.variableFluid = variableFluid;
            this.variableCapacity = variableCapacity;
            this.variableDirection = variableDirection;
            this.variableStart = variableStart;
            this.variableEnd = variableEnd;
            this.global = global;
        }

        @Override
        public void update(TileEntityAssembly tile) {
            AssemblyProcessor processor = tile.getProcessor();
            this.variableFluid.stashValue(processor);
            this.variableStart.stashValue(processor);
            this.variableEnd.stashValue(processor);
            this.variableCapacity.stashValue(processor);
        }

        @Override
        public void render(TileEntityAssembly tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
            super.render(tile, x, y, z, partialTicks, destroyStage, alpha);
            AssemblyProcessor assembly = tile.getProcessor();
            if (!this.isActive(assembly)) {
                return;
            }
            FluidStack stack = this.variableFluid.getFluid(assembly);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            if (stack != null) {
                EnumFacing facing = assembly.getFacing();
                Fluid fluid = stack.getFluid();
                int capacity = this.variableCapacity.getInteger(assembly, partialTicks);
                int amount = stack.amount;
                int c = fluid.getColor(stack);
                double slide = (double)amount / (double)capacity;
                Vec3d start = this.variableStart.getVector(assembly, partialTicks);
                Vec3d end = this.variableEnd.getVector(assembly, partialTicks);
                if (!this.global) {
                    start = Misc.getLocalVector(start.func_72441_c(-0.5, -0.5, -0.5), facing).func_72441_c(0.5, 0.5, 0.5);
                    end = Misc.getLocalVector(end.func_72441_c(-0.5, -0.5, -0.5), facing).func_72441_c(0.5, 0.5, 0.5);
                }
                EnumFacing direction = this.variableDirection.getFacing(assembly);
                double xWest = Math.min(start.field_72450_a, end.field_72450_a);
                double xEast = Math.max(start.field_72450_a, end.field_72450_a);
                double yDown = Math.min(start.field_72448_b, end.field_72448_b);
                double yUp = Math.max(start.field_72448_b, end.field_72448_b);
                double zNorth = Math.min(start.field_72449_c, end.field_72449_c);
                double zSouth = Math.max(start.field_72449_c, end.field_72449_c);
                double width = (xEast - xWest) * slide;
                double height = (yUp - yDown) * slide;
                double depth = (zSouth - zNorth) * slide;
                switch (direction) {
                    case DOWN: {
                        yDown = yUp - height;
                        break;
                    }
                    case UP: {
                        yUp = yDown + height;
                        break;
                    }
                    case NORTH: {
                        zNorth = zSouth - depth;
                        break;
                    }
                    case SOUTH: {
                        zSouth = zNorth + depth;
                        break;
                    }
                    case WEST: {
                        xWest = xEast - width;
                        break;
                    }
                    case EAST: {
                        xEast = xWest + width;
                    }
                }
                GlStateManager.func_179129_p();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderUtil.renderFluidCuboid(stack, tile.func_174877_v(), xWest, yDown, zNorth, xEast, yUp, zSouth, c);
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static class DisplayItem
    extends MachineVisual {
        Parameter variableItem;
        Parameter variablePosition;
        Parameter variableScale;
        Parameter variableRotation;
        boolean global;

        public DisplayItem(Parameter variableActive, Parameter variableItem, Parameter variablePosition, Parameter variableScale, Parameter variableRotation, boolean global) {
            super(variableActive);
            this.variableItem = variableItem;
            this.variablePosition = variablePosition;
            this.variableScale = variableScale;
            this.variableRotation = variableRotation;
            this.global = global;
        }

        @Override
        public void update(TileEntityAssembly tile) {
            AssemblyProcessor processor = tile.getProcessor();
            this.variablePosition.stashValue(processor);
            this.variableScale.stashValue(processor);
            this.variableRotation.stashValue(processor);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(TileEntityAssembly tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
            AssemblyProcessor assembly = tile.getProcessor();
            if (!this.isActive(assembly)) {
                return;
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            ItemStack stack = this.variableItem.getItem(assembly);
            if (!stack.func_190926_b() && Minecraft.func_71410_x().field_71441_e != null) {
                GL11.glPushMatrix();
                EnumFacing facing = assembly.getFacing();
                Vec3d pos = this.variablePosition.getVector(assembly, partialTicks);
                Vec3d rotation = this.variableRotation.getVector(assembly, partialTicks);
                double scale = this.variableScale.getDouble(assembly, partialTicks);
                if (!this.global) {
                    pos = Misc.getLocalVector(pos.func_72441_c(-0.5, -0.5, -0.5), facing).func_72441_c(0.5, 0.5, 0.5);
                    rotation = Misc.getLocalVector(rotation, facing);
                }
                GL11.glTranslated((double)(x + pos.field_72450_a), (double)(y + pos.field_72448_b), (double)(z + pos.field_72449_c));
                GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
                switch (facing) {
                    case DOWN: {
                        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case UP: {
                        break;
                    }
                    case NORTH: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                GL11.glScaled((double)scale, (double)scale, (double)scale);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GL11.glPopMatrix();
            }
        }
    }

    public static class DisplayModel
    extends MachineVisual {
        Parameter variableModel;
        Parameter variablePosition;
        Parameter variableScale;
        Parameter variableRotation;
        boolean global;

        public DisplayModel(Parameter variableActive, Parameter variableModel, Parameter variablePosition, Parameter variableScale, Parameter variableRotation, boolean global) {
            super(variableActive);
            this.variableModel = variableModel;
            this.variablePosition = variablePosition;
            this.variableScale = variableScale;
            this.variableRotation = variableRotation;
            this.global = global;
        }

        @Override
        public void update(TileEntityAssembly tile) {
            AssemblyProcessor processor = tile.getProcessor();
            this.variablePosition.stashValue(processor);
            this.variableScale.stashValue(processor);
            this.variableRotation.stashValue(processor);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(TileEntityAssembly tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
            AssemblyProcessor assembly = tile.getProcessor();
            if (!this.isActive(assembly)) {
                return;
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            ModelResourceLocation model = new ModelResourceLocation(this.variableModel.getString(assembly));
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
            if (model != null && Minecraft.func_71410_x().field_71441_e != null) {
                GL11.glPushMatrix();
                IBakedModel ibakedmodel = modelmanager.func_174953_a(model);
                EnumFacing facing = assembly.getFacing();
                Vec3d pos = this.variablePosition.getVector(assembly, partialTicks);
                Vec3d rotation = this.variableRotation.getVector(assembly, partialTicks);
                double scale = this.variableScale.getDouble(assembly, partialTicks);
                if (!this.global) {
                    pos = Misc.getLocalVector(pos.func_72441_c(-0.5, -0.5, -0.5), facing).func_72441_c(0.5, 0.5, 0.5);
                    rotation = Misc.getLocalVector(rotation, facing);
                }
                GL11.glTranslated((double)(x + pos.field_72450_a), (double)(y + pos.field_72448_b), (double)(z + pos.field_72449_c));
                GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
                switch (facing) {
                    case DOWN: {
                        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case UP: {
                        break;
                    }
                    case NORTH: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                GL11.glScaled((double)scale, (double)scale, (double)scale);
                blockrendererdispatcher.func_175019_b().func_178262_a(ibakedmodel, 1.0f, 1.0f, 1.0f, 1.0f);
                GL11.glPopMatrix();
            }
        }
    }
}

