/*
 * Decompiled with CFR 0.152.
 */
package requious.tile;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import requious.Requious;
import requious.block.BlockEmitter;
import requious.entity.EntitySpark;
import requious.entity.spark.TargetTile;
import requious.particle.IParticleAnchor;
import requious.tile.ISparkAcceptor;
import requious.tile.ITargetable;
import requious.util.Misc;

public abstract class TileEntityEmitter
extends TileEntity
implements ITickable,
ISparkAcceptor,
ITargetable {
    Random random = new Random();
    public long ticksExisted = 0L;
    int offset = this.random.nextInt(60);
    public BlockPos target = null;
    PathVisual visual = null;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this, false);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        EnumFacing facing = this.getFacing();
        TileEntity attachedTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()));
        if (attachedTile != null && !this.func_145831_w().field_72995_K) {
            this.ioEnergy(facing, attachedTile);
        }
        if ((this.ticksExisted + (long)this.offset) % (long)this.getInterval() == 0L && this.target != null && !this.func_145831_w().field_72995_K) {
            this.sendPacket();
        }
        if (this.field_145850_b.field_72995_K && this.target != null && Requious.PROXY.shouldRenderArcs()) {
            double targetX = (double)this.target.func_177958_n() + 0.5;
            double targetY = (double)this.target.func_177956_o() + 0.5;
            double targetZ = (double)this.target.func_177952_p() + 0.5;
            if (this.visual != null) {
                int segments = 4;
                for (int i = 0; i < segments; ++i) {
                    float partial = 1.0f - (float)i / (float)segments;
                    this.visual.update(targetX, targetY, targetZ);
                    Requious.PROXY.emitGlow(this.field_145850_b, IParticleAnchor.zero(), this.visual.posX, this.visual.posY, this.visual.posZ, 0.0, 0.0, 0.0, new Color(255, 255, 255), 0.5f, 2.0f, 20, partial);
                }
                if (this.visual.arrived) {
                    this.visual = null;
                }
            } else {
                Vec3d velocity = this.getBurstVelocity(facing);
                this.visual = new PathVisual((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
        } else {
            this.visual = null;
        }
    }

    public TileEntity getTargetTile() {
        if (this.target == null) {
            return null;
        }
        return this.field_145850_b.func_175625_s(this.target);
    }

    public boolean isReceiver() {
        return this.target == null;
    }

    public boolean isEmitter() {
        return this.target != null;
    }

    abstract void ioEnergy(EnumFacing var1, TileEntity var2);

    abstract void sendPacket();

    abstract void receivePacket(EntitySpark var1);

    abstract int getInterval();

    protected EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockEmitter.facing);
    }

    protected Vec3d getBurstVelocity(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3d(0.0, -0.5, 0.0);
            }
            case UP: {
                return new Vec3d(0.0, 0.5, 0.0);
            }
            case NORTH: {
                return new Vec3d(0.0, -0.01, -0.5);
            }
            case SOUTH: {
                return new Vec3d(0.0, -0.01, 0.5);
            }
            case WEST: {
                return new Vec3d(-0.5, -0.01, 0.0);
            }
            case EAST: {
                return new Vec3d(0.5, -0.01, 0.0);
            }
        }
        return Vec3d.field_186680_a;
    }

    @Override
    public void receive(EntitySpark spark) {
        if (this.target != null) {
            spark.target = new TargetTile(this.target);
            spark.lifetime = spark.value.getLifetime(spark);
            spark.pushHistory((Comparable)this.field_174879_c);
        } else {
            this.receivePacket(spark);
            spark.setReceived(true);
        }
    }

    static class PathVisual {
        double posX;
        double posY;
        double posZ;
        double motionX;
        double motionY;
        double motionZ;
        boolean arrived;

        public PathVisual(double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.motionX = motionX;
            this.motionY = motionY;
            this.motionZ = motionZ;
        }

        public void update(double targetX, double targetY, double targetZ) {
            Vec3d targetVector = new Vec3d(targetX - this.posX, targetY - this.posY, targetZ - this.posZ);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            this.motionX = (0.9 - weight) * this.motionX + (0.1 + weight) * targetVector.field_72450_a;
            this.motionY = (0.9 - weight) * this.motionY + (0.1 + weight) * targetVector.field_72448_b;
            this.motionZ = (0.9 - weight) * this.motionZ + (0.1 + weight) * targetVector.field_72449_c;
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            double distanceSq = this.getDistanceSq(targetX, targetY, targetZ);
            if (distanceSq < 0.1) {
                this.arrived = true;
            }
        }

        private double getDistanceSq(double targetX, double targetY, double targetZ) {
            double dx = targetX - this.posX;
            double dy = targetY - this.posY;
            double dz = targetZ - this.posZ;
            return dx * dx + dy * dy + dz * dz;
        }
    }
}

