/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import requious.compat.crafttweaker.RecipeContainer;
import requious.compat.jei.JEISlot;
import requious.compat.jei.slot.ItemSlot;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentItem;
import requious.recipe.ConsumptionResult;
import requious.recipe.MatchResult;
import requious.recipe.RequirementBase;

public class RequirementIngredient
extends RequirementBase {
    IIngredient ingredient;
    int min;
    int max;

    public RequirementIngredient(String group, IIngredient ingredient) {
        this(group, ingredient, ingredient.getAmount(), ingredient.getAmount());
    }

    public RequirementIngredient(String group, IIngredient ingredient, int min, int max) {
        super(group);
        this.ingredient = ingredient;
        this.min = min;
        this.max = max;
    }

    @Override
    public MatchResult matches(ComponentBase.Slot slot, ConsumptionResult result) {
        ItemStack stack;
        if (slot instanceof ComponentItem.Slot && slot.isGroup(this.group) && this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)(stack = ((ComponentItem.Slot)slot).getItem().getStack()))) && stack.func_190916_E() >= this.min) {
            result.add(Math.min(this.max, stack.func_190916_E()));
            return MatchResult.MATCHED;
        }
        return MatchResult.NOT_MATCHED;
    }

    @Override
    public void fillContainer(ComponentBase.Slot slot, ConsumptionResult result, RecipeContainer container) {
        if (this.ingredient.getMark() != null) {
            container.addInput(this.ingredient.getMark(), ((ComponentItem.Slot)slot).getItem().extract((Integer)result.getConsumed(), true));
        }
    }

    @Override
    public void consume(ComponentBase.Slot slot, ConsumptionResult result) {
        if (slot instanceof ComponentItem.Slot && result instanceof ConsumptionResult.Integer) {
            ((ComponentItem.Slot)slot).getItem().extract((Integer)result.getConsumed(), false);
        }
    }

    @Override
    public ConsumptionResult createResult() {
        return new ConsumptionResult.Integer((RequirementBase)this, 0);
    }

    @Override
    public boolean fillJEI(JEISlot slot) {
        if (slot instanceof ItemSlot && slot.group.equals(this.group) && !slot.isFilled()) {
            ItemSlot itemSlot = (ItemSlot)slot;
            if (this.ingredient.getItems() != null) {
                for (IItemStack stack : this.ingredient.getItems()) {
                    ItemStack jeiStack = CraftTweakerMC.getItemStack((IItemStack)stack);
                    jeiStack.func_190920_e(this.ingredient.getAmount());
                    itemSlot.items.add(jeiStack);
                }
            }
            itemSlot.setInput(true);
            return true;
        }
        return false;
    }
}

