/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import requious.compat.crafttweaker.RecipeContainer;
import requious.compat.jei.JEISlot;
import requious.compat.jei.ingredient.Energy;
import requious.compat.jei.slot.EnergySlot;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentEnergy;
import requious.recipe.ConsumptionResult;
import requious.recipe.MatchResult;
import requious.recipe.RequirementBase;

public class RequirementEnergy
extends RequirementBase {
    String mark;
    int min;
    int max;

    public RequirementEnergy(String group, int energy, String mark) {
        this(group, energy, energy, mark);
    }

    public RequirementEnergy(String group, int min, int max, String mark) {
        super(group);
        this.mark = mark;
        this.min = min;
        this.max = max;
    }

    @Override
    public MatchResult matches(ComponentBase.Slot slot, ConsumptionResult result) {
        int extracted;
        if (slot instanceof ComponentEnergy.Slot && slot.isGroup(this.group) && (extracted = ((ComponentEnergy.Slot)slot).extract(this.max, true)) >= this.min) {
            result.add(extracted);
            return MatchResult.MATCHED;
        }
        return MatchResult.NOT_MATCHED;
    }

    @Override
    public void fillContainer(ComponentBase.Slot slot, ConsumptionResult result, RecipeContainer container) {
        if (this.mark != null) {
            container.addInput(this.mark, (Integer)result.consumed);
        }
    }

    @Override
    public void consume(ComponentBase.Slot slot, ConsumptionResult result) {
        if (slot instanceof ComponentEnergy.Slot && result instanceof ConsumptionResult.Integer) {
            ((ComponentEnergy.Slot)slot).extract((Integer)result.getConsumed(), false);
        }
    }

    @Override
    public ConsumptionResult createResult() {
        return new ConsumptionResult.Integer((RequirementBase)this, 0);
    }

    @Override
    public boolean fillJEI(JEISlot slot) {
        if (slot instanceof EnergySlot && slot.group.equals(this.group) && ((EnergySlot)slot).input == null) {
            EnergySlot energySlot = (EnergySlot)slot;
            energySlot.input = new Energy(this.min, energySlot.unit);
            return true;
        }
        return false;
    }
}

