/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import requious.compat.jei.IngredientCollector;
import requious.compat.jei.JEISlot;
import requious.recipe.AssemblyRecipe;

public class AssemblyJEIWrapper
implements IRecipeWrapper {
    public AssemblyRecipe recipe;

    public AssemblyJEIWrapper(AssemblyRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        this.recipe.generateJEI();
        IngredientCollector collector = new IngredientCollector();
        for (JEISlot slot : this.recipe.jeiSlots) {
            slot.getIngredients(collector);
        }
        collector.collect(ingredients);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        for (JEISlot slot : this.recipe.jeiSlots) {
            slot.render(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ITooltipFlag.TooltipFlags tooltipFlag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        ArrayList<String> tooltip = new ArrayList<String>();
        for (JEISlot slot : this.recipe.jeiSlots) {
            if (mouseX < slot.x * 18 || mouseY < slot.y * 18 || mouseX >= slot.x * 18 + 18 || mouseY >= slot.y * 18 + 18) continue;
            slot.getTooltip(tooltip, tooltipFlag);
        }
        return tooltip;
    }
}

