/*
 * Decompiled with CFR 0.152.
 */
package requious.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import requious.item.Shape;
import requious.model.ModelShapeBaked;
import requious.model.TextureConverter;

public class ModelShape
implements IModel {
    public static final ResourceLocation TOP_LEFT = new ResourceLocation("requious", "items/shape_topleft");
    public static final ResourceLocation TOP_RIGHT = new ResourceLocation("requious", "items/shape_topright");
    public static final ResourceLocation BOTTOM_LEFT = new ResourceLocation("requious", "items/shape_bottomleft");
    public static final ResourceLocation BOTTOM_RIGHT = new ResourceLocation("requious", "items/shape_bottomright");
    public static ModelShape MODEL = new ModelShape();

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)new ResourceLocation("requious", "items/shape_topleft"), (Object)new ResourceLocation("requious", "items/shape_topright"), (Object)new ResourceLocation("requious", "items/shape_bottomleft"), (Object)new ResourceLocation("requious", "items/shape_bottomright"));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakingModel((ImmutableList<BakedQuad>)ImmutableList.of(), bakedTextureGetter.apply(new ResourceLocation("missingno")), state, format);
    }

    public static class OverrideList
    extends ItemOverrideList {
        public static final OverrideList INSTANCE = new OverrideList();

        public OverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            BakingModel model = (BakingModel)originalModel;
            ResourceLocation circle = new ResourceLocation("requious", "items/shape_circle");
            ResourceLocation square = new ResourceLocation("requious", "items/shape_square");
            ResourceLocation star = new ResourceLocation("requious", "items/shape_star");
            Shape shapeInnerInner = new Shape();
            shapeInnerInner.setPart(Shape.Piece.BOTTOM_LEFT, new Shape.Part(circle, "iron", Color.YELLOW));
            shapeInnerInner.setPart(Shape.Piece.BOTTOM_RIGHT, new Shape.Part(circle, "iron", Color.YELLOW));
            shapeInnerInner.setPart(Shape.Piece.TOP_RIGHT, new Shape.Part(circle, "iron", Color.YELLOW));
            shapeInnerInner.setPart(Shape.Piece.TOP_LEFT, new Shape.Part(circle, "iron", Color.YELLOW));
            Shape shapeInner = new Shape();
            shapeInner.setPart(Shape.Piece.BOTTOM_LEFT, new Shape.Part(star, "iron", Color.RED));
            shapeInner.setPart(Shape.Piece.BOTTOM_RIGHT, new Shape.Part(star, "iron", Color.RED));
            shapeInner.setPart(Shape.Piece.TOP_RIGHT, new Shape.Part(star, "iron", Color.RED));
            shapeInner.setPart(Shape.Piece.TOP_LEFT, new Shape.Part(star, "iron", Color.RED));
            shapeInner.setInner(shapeInnerInner);
            Shape shape = new Shape();
            shape.setPart(Shape.Piece.BOTTOM_LEFT, new Shape.Part(circle, "iron", Color.GRAY));
            shape.setPart(Shape.Piece.BOTTOM_RIGHT, new Shape.Part(circle, "iron", Color.GRAY));
            shape.setPart(Shape.Piece.TOP_RIGHT, new Shape.Part(square, "iron", Color.GRAY));
            shape.setPart(Shape.Piece.TOP_LEFT, new Shape.Part(star, "iron", Color.BLACK));
            shape.setInner(shapeInner);
            if (!model.cache.containsKey(shape)) {
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = model.bake(shape, textureGetter);
                model.cache.put(shape, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(shape);
        }
    }

    public static class BakingModel
    extends BakedItemModel {
        private final Map<Shape, IBakedModel> cache = new HashMap<Shape, IBakedModel>();
        private final IModelState state;
        private final VertexFormat format;
        private static final float NORTH_Z = 0.468625f;
        private static final float SOUTH_Z = 0.531375f;

        BakingModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, IModelState state, VertexFormat format) {
            super(quads, particle, Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((IModelState)state)), (ItemOverrideList)OverrideList.INSTANCE, state.apply(Optional.empty()).orElse(TRSRTransformation.identity()).isIdentity());
            this.state = state;
            this.format = format;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public IBakedModel bake(Shape shape, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.bakeShape(shape, (ImmutableList.Builder<BakedQuad>)builder, bakedTextureGetter, 0);
            return new ModelShapeBaked((List<BakedQuad>)builder.build(), this.state);
        }

        private void bakeShape(Shape shape, ImmutableList.Builder<BakedQuad> builder, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, int scale) {
            if (shape == null) {
                return;
            }
            TRSRTransformation transform = this.state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
            transform = this.scale(transform, scale);
            this.bakePart(shape.getPart(Shape.Piece.TOP_LEFT), bakedTextureGetter.apply(TOP_LEFT), builder, bakedTextureGetter, transform);
            this.bakePart(shape.getPart(Shape.Piece.TOP_RIGHT), bakedTextureGetter.apply(TOP_RIGHT), builder, bakedTextureGetter, transform);
            this.bakePart(shape.getPart(Shape.Piece.BOTTOM_LEFT), bakedTextureGetter.apply(BOTTOM_LEFT), builder, bakedTextureGetter, transform);
            this.bakePart(shape.getPart(Shape.Piece.BOTTOM_RIGHT), bakedTextureGetter.apply(BOTTOM_RIGHT), builder, bakedTextureGetter, transform);
            this.bakeShape(shape.getInner(), builder, bakedTextureGetter, scale + 1);
        }

        private void bakePart(Shape.Part part, TextureAtlasSprite mask, ImmutableList.Builder<BakedQuad> builder, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, TRSRTransformation transform) {
            if (part == null) {
                return;
            }
            TextureAtlasSprite sprite = bakedTextureGetter.apply(part.getTexture());
            builder.addAll(TextureConverter.getQuadsForSprite(1, part.getColor().getRGB(), mask, sprite, this.format, transform));
        }

        private TRSRTransformation scale(TRSRTransformation transformation, int scaleMod) {
            Matrix4f matrix = transformation.getMatrix();
            float r = 0.66f;
            float scale = (float)Math.pow(r, scaleMod);
            float offset = 1.0f - scale;
            TRSRTransformation multTransform = new TRSRTransformation(new Vector3f(offset / 2.0f, offset / 2.0f, -0.005f * (float)scaleMod), null, new Vector3f(scale, scale, 1.0f + 0.01f * (float)scaleMod), null);
            matrix.mul(multTransform.getMatrix());
            return new TRSRTransformation(matrix);
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        ResourceLocation resourceLocation;

        public Loader(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals(this.resourceLocation.func_110624_b()) && modelLocation.func_110623_a().contains(this.resourceLocation.func_110623_a());
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return MODEL;
        }
    }
}

