/*
 * Decompiled with CFR 0.152.
 */
package requious.item;

import crafttweaker.api.minecraft.CraftTweakerMC;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import requious.data.FluidCellData;
import requious.item.IDynamicItemModel;

public class ItemFluidCell
extends Item
implements IDynamicItemModel {
    FluidCellData data;

    public ItemFluidCell(FluidCellData data) {
        this.data = data;
        this.func_185043_a(new ResourceLocation("requious", "fluid"), (stack, worldIn, entityIn) -> {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluid != null) {
                return (float)fluid.amount / (float)this.getCapacity();
            }
            return 0.0f;
        });
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        int capacity = this.getCapacity();
        if (this.data.showToolip) {
            if (fluid == null) {
                tooltip.add(I18n.func_135052_a((String)"requious.fluid.empty", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"requious.fluid", (Object[])new Object[]{fluid.getLocalizedName(), fluid.amount, capacity}));
            }
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.data.stackSize;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        FluidStack fluid = this.getFluid(itemStack);
        return this.data.getFuelValue(fluid);
    }

    public boolean func_77614_k() {
        return this.data.generateSubItems;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getEmpty());
            if (this.data.generateSubItems) {
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    FluidStack stack = new FluidStack(fluid, this.data.capacity);
                    if (this.data.filter != null && !this.data.filter.matches(CraftTweakerMC.getILiquidStack((FluidStack)stack))) continue;
                    items.add((Object)this.getFilled(stack));
                }
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        return fluid != null && this.data.hasBar();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        double lerp = 1.0 - this.getDurabilityForDisplay(stack);
        return this.data.barColor.get(lerp).getRGB();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null) {
            return 1.0 - (double)fluid.amount / (double)this.getCapacity();
        }
        return 1.0;
    }

    public ItemStack getEmpty() {
        return new ItemStack((Item)this);
    }

    public ItemStack getFilled(FluidStack fluid) {
        NBTTagCompound compound;
        ItemStack container = this.getEmpty();
        NBTTagCompound fluidTag = new NBTTagCompound();
        if (fluid != null) {
            fluidTag = fluid.writeToNBT(fluidTag);
        }
        if ((compound = container.func_77978_p()) == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74782_a("fluidContent", (NBTBase)fluidTag);
        container.func_77982_d(compound);
        return container;
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("fluidContent")) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluidContent"));
        }
        return null;
    }

    private int getCapacity() {
        return this.data.capacity;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new FluidCellCapability(stack);
    }

    @Override
    public Color getTint(ItemStack stack, int tintIndex) {
        return this.data.getColor(stack, tintIndex);
    }

    private int getMinInput() {
        return this.data.minInput;
    }

    private int getMaxInput() {
        return this.data.maxInput;
    }

    private int getMinOutput() {
        return this.data.minOutput;
    }

    private int getMaxOutput() {
        return this.data.maxOutput;
    }

    public class FluidCellCapability
    implements IFluidHandlerItem,
    ICapabilityProvider {
        @Nonnull
        protected ItemStack container;

        public FluidCellCapability(ItemStack container) {
            this.container = container;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(ItemFluidCell.this.getFluid(this.container), ItemFluidCell.this.getCapacity())};
        }

        private void setFluid(FluidStack resource) {
            this.container = resource == null || resource.amount <= 0 ? ItemFluidCell.this.getEmpty() : ItemFluidCell.this.getFilled(resource);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.container.func_190916_E() != 1 || resource == null) {
                return 0;
            }
            FluidStack fluid = ItemFluidCell.this.getFluid(this.container);
            int maxFill = Math.min(resource.amount, ItemFluidCell.this.getMaxInput());
            if (fluid != null) {
                if (!fluid.isFluidEqual(resource)) {
                    return 0;
                }
                maxFill = Math.min(maxFill, ItemFluidCell.this.getCapacity() - fluid.amount);
            } else {
                maxFill = Math.min(maxFill, ItemFluidCell.this.getCapacity());
                fluid = resource.copy();
                fluid.amount = 0;
            }
            if (maxFill < ItemFluidCell.this.getMinInput()) {
                return 0;
            }
            fluid.amount += maxFill;
            if (doFill) {
                this.setFluid(fluid);
            }
            return maxFill;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.container.func_190916_E() != 1 || resource == null) {
                return null;
            }
            FluidStack fluid = ItemFluidCell.this.getFluid(this.container);
            int maxDrain = Math.min(resource.amount, ItemFluidCell.this.getMaxOutput());
            if (fluid != null && fluid.isFluidEqual(resource) && resource.amount >= ItemFluidCell.this.getMinOutput()) {
                FluidStack drained = fluid.copy();
                drained.amount = Math.min(maxDrain, fluid.amount);
                fluid.amount -= drained.amount;
                if (fluid.amount < 0) {
                    fluid = null;
                }
                if (doDrain) {
                    this.setFluid(fluid);
                }
                return drained;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.container.func_190916_E() != 1) {
                return null;
            }
            FluidStack fluid = ItemFluidCell.this.getFluid(this.container);
            maxDrain = Math.min(maxDrain, ItemFluidCell.this.getMaxOutput());
            if (fluid != null && maxDrain >= ItemFluidCell.this.getMinOutput()) {
                FluidStack drained = fluid.copy();
                drained.amount = Math.min(maxDrain, fluid.amount);
                fluid.amount -= drained.amount;
                if (fluid.amount < 0) {
                    fluid = null;
                }
                if (doDrain) {
                    this.setFluid(fluid);
                }
                return drained;
            }
            return null;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
            }
            return null;
        }
    }
}

