/*
 * Decompiled with CFR 0.152.
 */
package requious.gui.slot;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.energy.CapabilityEnergy;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentEnergy;
import requious.gui.GuiAssembly;
import requious.gui.slot.BaseSlot;
import requious.util.Fill;
import requious.util.SlotVisual;

public class EnergySlot
extends BaseSlot<ComponentEnergy.Slot> {
    public EnergySlot(AssemblyProcessor assembly, ComponentEnergy.Slot binding, int xPosition, int yPosition) {
        super(assembly, binding, xPosition, yPosition);
    }

    public boolean func_75214_a(ItemStack stack) {
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return ((ComponentEnergy.Slot)this.binding).getItem().getStack();
    }

    public void func_75215_d(ItemStack stack) {
        ((ComponentEnergy.Slot)this.binding).getItem().setStack(stack);
        this.func_75218_e();
    }

    public void func_75220_a(ItemStack p_75220_1_, ItemStack p_75220_2_) {
    }

    public int func_75219_a() {
        return ((ComponentEnergy.Slot)this.binding).getItem().getCapacity();
    }

    public int func_178170_b(ItemStack stack) {
        if (!((ComponentEnergy.Slot)this.binding).canPut()) {
            return ((ComponentEnergy.Slot)this.binding).getItem().getAmount();
        }
        return ((ComponentEnergy.Slot)this.binding).getItem().getCapacity();
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        if (!((ComponentEnergy.Slot)this.binding).canTake()) {
            return false;
        }
        return !((ComponentEnergy.Slot)this.binding).getItem().extract(1, true).func_190926_b();
    }

    @Override
    public void incrStack(int n) {
        ((ComponentEnergy.Slot)this.binding).getItem().insert(n, false);
    }

    @Override
    public void renderBackground(GuiAssembly assembly, int x, int y, float partialTicks, int mousex, int mousey) {
        SlotVisual background = ((ComponentEnergy.Slot)this.binding).getBackground();
        int energy = ((ComponentEnergy.Slot)this.binding).getAmount();
        int capacity = ((ComponentEnergy.Slot)this.binding).getCapacity();
        background.render(assembly.field_146297_k, x - 1, y - 1, 100, new Fill(energy, capacity));
    }

    @Override
    public void renderForeground(GuiAssembly assembly, int x, int y, int mousex, int mousey) {
        SlotVisual foreground = ((ComponentEnergy.Slot)this.binding).getForeground();
        int energy = ((ComponentEnergy.Slot)this.binding).getAmount();
        int capacity = ((ComponentEnergy.Slot)this.binding).getCapacity();
        if (foreground != null) {
            foreground.render(assembly.field_146297_k, x - 1, y - 1, 1000, new Fill(energy, capacity));
        }
    }

    @Override
    public boolean hasToolTip() {
        return this.shouldRender();
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        String unit = ((ComponentEnergy.Slot)this.binding).getUnit();
        if (unit != null && I18n.func_188566_a((String)("requious.unit." + unit))) {
            tooltip.add(I18n.func_135052_a((String)("requious.unit." + unit), (Object[])new Object[]{((ComponentEnergy.Slot)this.binding).getAmount(), ((ComponentEnergy.Slot)this.binding).getCapacity()}));
        }
        return tooltip;
    }

    public ItemStack func_75209_a(int amount) {
        return ((ComponentEnergy.Slot)this.binding).getItem().extract(amount, false);
    }

    @Override
    public boolean func_111238_b() {
        return !((ComponentEnergy.Slot)this.binding).isHidden() && ((ComponentEnergy.Slot)this.binding).isBatteryAccepted();
    }

    @Override
    public boolean isHoverEnabled() {
        return true;
    }

    @Override
    public Vec3i getSize() {
        SlotVisual background = ((ComponentEnergy.Slot)this.binding).getBackground();
        return new Vec3i(background.getWidth() * 18 - 2, background.getHeight() * 18 - 2, 0);
    }

    @Override
    public boolean canShiftPut() {
        return super.canShiftPut() && ((ComponentEnergy.Slot)this.binding).canPut();
    }

    @Override
    public boolean canShiftTake() {
        return super.canShiftTake() && ((ComponentEnergy.Slot)this.binding).canTake();
    }
}

