/*
 * Decompiled with CFR 0.152.
 */
package requious.entity;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import requious.Requious;
import requious.entity.ISparkTarget;
import requious.entity.ISparkValue;
import requious.entity.SparkEffect;
import requious.particle.IParticleAnchor;
import requious.tile.ISparkAcceptor;
import requious.util.ExtraSerializers;

public class EntitySpark
extends Entity {
    static List<ISparkValue.Deserializer> valueDeserializers = new ArrayList<ISparkValue.Deserializer>();
    static List<ISparkTarget.Deserializer> targetDeserializers = new ArrayList<ISparkTarget.Deserializer>();
    public static final DataParameter<Float> size = EntityDataManager.func_187226_a(EntitySpark.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> color = EntityDataManager.func_187226_a(EntitySpark.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<SparkEffect> effect = EntityDataManager.func_187226_a(EntitySpark.class, ExtraSerializers.SPARK_EFFECT);
    public int lifetime = 80;
    public ISparkTarget target;
    public ISparkValue value;
    List<Comparable> history = new ArrayList<Comparable>();
    public double lastX;
    public double lastY;
    public double lastZ;
    boolean received;

    public static void registerValue(ISparkValue.Deserializer deserializer) {
        valueDeserializers.add(deserializer);
    }

    public static void registerTarget(ISparkTarget.Deserializer deserializer) {
        targetDeserializers.add(deserializer);
    }

    public EntitySpark(World worldIn) {
        super(worldIn);
    }

    public void init(double x, double y, double z, double vx, double vy, double vz, @Nonnull ISparkTarget target, @Nonnull ISparkValue value) {
        this.func_70107_b(x, y, z);
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.target = target;
        this.value = value;
        this.lifetime = value.getLifetime(this);
    }

    public void pushHistory(Comparable token) {
        if (this.history.contains(token)) {
            this.func_70106_y();
        }
        this.history.add(token);
    }

    public void setReceived(boolean received) {
        this.received = received;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(size, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(color, (Object)-1);
        this.func_184212_Q().func_187214_a(effect, (Object)SparkEffect.LightningBall);
    }

    private void updateVisuals() {
        this.func_184212_Q().func_187227_b(size, (Object)Float.valueOf(this.value.getSize(this)));
        this.func_184212_Q().func_187227_b(color, (Object)this.value.getColor(this).getRGB());
        this.func_184212_Q().func_187227_b(effect, (Object)this.value.getEffect(this));
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.setReceived(true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.lifetime;
        if (!this.field_70128_L && this.lifetime <= 0 || this.received) {
            this.func_70106_y();
        }
        if (this.lastX == 0.0 && this.lastY == 0.0 && this.lastZ == 0.0) {
            this.lastX = this.field_70165_t;
            this.lastY = this.field_70163_u;
            this.lastZ = this.field_70161_v;
        }
        if (this.field_70170_p.field_72995_K) {
            double deltaX = this.field_70165_t - this.lastX;
            double deltaY = this.field_70163_u - this.lastY;
            double deltaZ = this.field_70161_v - this.lastZ;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            for (double i = 0.0; i < dist; i += 1.0) {
                double d = i / dist;
            }
            int segments = 1;
            Requious.PROXY.spawnLightning(this.field_70170_p, IParticleAnchor.zero(), this.lastX, this.lastY, this.lastZ, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4, 0.2, new Color(255, 16, 16), 1.4f, 10);
            double distanceMod = this.field_70146_Z.nextDouble();
            for (int i = 0; i < segments; ++i) {
                double distanceA = this.field_70146_Z.nextDouble() * 0.2 + 0.2;
                double distanceB = this.field_70146_Z.nextDouble() * 0.4 + 0.2;
                Vec3d offsetA = Vec3d.func_189986_a((float)((float)(this.field_70146_Z.nextDouble() * 360.0)), (float)((float)(this.field_70146_Z.nextDouble() * 360.0))).func_186678_a(0.0);
                Vec3d vec3d = Vec3d.func_189986_a((float)((float)(this.field_70146_Z.nextDouble() * 360.0)), (float)((float)(this.field_70146_Z.nextDouble() * 360.0))).func_186678_a(distanceB * distanceMod);
            }
            this.lastX = this.field_70165_t;
            this.lastY = this.field_70163_u;
            this.lastZ = this.field_70161_v;
        }
        if (!(this.field_70170_p.field_72995_K || this.target != null && this.target.isValid(this))) {
            this.func_70106_y();
        }
        if (!this.received && !this.field_70170_p.field_72995_K) {
            Vec3d dest = this.target.getPosition(this);
            boolean cont = true;
            for (int i = 0; i < 4 && cont && !this.received; ++i) {
                cont = this.moveStep(dest);
            }
            this.updateVisuals();
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private boolean moveStep(Vec3d dest) {
        ISparkAcceptor acceptor;
        double targetX = dest.field_72450_a;
        double targetY = dest.field_72448_b;
        double targetZ = dest.field_72449_c;
        Vec3d targetVector = new Vec3d(targetX - this.field_70165_t, targetY - this.field_70163_u, targetZ - this.field_70161_v);
        double length = targetVector.func_72433_c();
        if (length != 0.0) {
            targetVector = targetVector.func_186678_a(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            this.field_70159_w = (0.9 - weight) * this.field_70159_w + (0.1 + weight) * targetVector.field_72450_a;
            this.field_70181_x = (0.9 - weight) * this.field_70181_x + (0.1 + weight) * targetVector.field_72448_b;
            this.field_70179_y = (0.9 - weight) * this.field_70179_y + (0.1 + weight) * targetVector.field_72449_c;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        double distanceSq = this.func_70092_e(targetX, targetY, targetZ);
        if (distanceSq < 0.1 && (acceptor = this.target.getAcceptor(this)) != null) {
            this.field_70165_t = targetX;
            this.field_70163_u = targetY;
            this.field_70161_v = targetZ;
            acceptor.receive(this);
            return false;
        }
        return true;
    }

    private ISparkValue deserializeValue(NBTTagCompound compound) {
        Iterator<ISparkValue.Deserializer> iterator = valueDeserializers.iterator();
        if (iterator.hasNext()) {
            ISparkValue.Deserializer deserializer = iterator.next();
            ISparkValue value = deserializer.deserialize(compound);
            if (value != null) {
                value.readFromNBT(compound);
            }
            return value;
        }
        return null;
    }

    private ISparkTarget deserializeTarget(NBTTagCompound compound) {
        for (ISparkTarget.Deserializer deserializer : targetDeserializers) {
            ISparkTarget target = deserializer.deserialize(compound);
            if (target == null) continue;
            target.readFromNBT(compound);
            return target;
        }
        return null;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.target = this.deserializeTarget(compound);
        this.value = this.deserializeValue(compound);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.target != null) {
            this.target.writeToNBT(compound);
        }
        if (this.value != null) {
            this.value.writeToNBT(compound);
        }
    }
}

