/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.tile.TileEntityAssembly;
import requious.util.ComponentFace;
import requious.util.ILaserStorage;
import requious.util.LaserUtil;
import requious.util.LaserVisual;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.LaserSlot")
public class ComponentLaser
extends ComponentBase {
    public boolean inputAllowed = true;
    public boolean outputAllowed = true;
    public int minReceive = 0;
    public int maxReceive = Integer.MAX_VALUE;
    public int minTargets = 1;
    public int maxTargets = 1;
    public HashSet<String> types = new HashSet();
    public Vec3i areaStart = Vec3i.field_177959_e;
    public Vec3i areaEnd = Vec3i.field_177959_e;

    public ComponentLaser(ComponentFace face) {
        super(face);
    }

    @Override
    public ComponentBase.Slot createSlot() {
        return new Slot(this);
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentLaser setAccess(boolean input, boolean output) {
        this.inputAllowed = input;
        this.outputAllowed = output;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentLaser setType(String type) {
        this.types.add(type);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentLaser setLimit(int min, int max) {
        this.minReceive = min;
        this.maxReceive = max;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentLaser setMultiTarget(int minTargets, int maxTargets) {
        this.minTargets = minTargets;
        this.maxTargets = maxTargets;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentLaser setArea(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.areaStart = new Vec3i(x1, y1, z1);
        this.areaEnd = new Vec3i(x2, y2, z2);
        return this;
    }

    public static class Collector
    extends ComponentBase.Collector
    implements ILaserStorage {
        ComponentFace face;
        List<Slot> slots = new ArrayList<Slot>();

        public Collector(ComponentFace face) {
            this.face = face;
        }

        public ComponentFace getFace() {
            return this.face;
        }

        private void addSlot(Slot slot) {
            this.slots.add(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot.getFace() == this.face && slot instanceof Slot) {
                this.addSlot((Slot)slot);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCapability() {
            return false;
        }

        @Override
        public void update() {
            for (Slot slot : this.slots) {
                slot.updateLaser(this.tile.func_145831_w(), this.tile.func_174877_v(), this.getTileFacing());
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Collector) {
                return this.face.equals((Object)((Collector)obj).face);
            }
            return false;
        }

        @Override
        public int receive(String type, int power, boolean simulate) {
            int received = 0;
            for (Slot slot : this.slots) {
                if (!slot.canAccept(type) && slot.canInput()) continue;
                received += slot.receive(type, power, simulate);
            }
            return received;
        }
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentLaser> {
        HashMap<String, Integer> energyCharge = new HashMap();
        HashMap<String, Integer> energy = new HashMap();
        int currentFacing = 0;
        int emitAmount;
        String emitType;
        LaserVisual emitVisual;
        LaserUtil util = new LaserUtil();

        public Slot(ComponentLaser component) {
            super(component);
        }

        public String getEmitType() {
            return this.emitType;
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
            Collector energy = new Collector(this.getFace());
            if (!collectors.contains(energy)) {
                collectors.add(energy);
            }
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return null;
        }

        public void updateLaser(World world, BlockPos pos, EnumFacing tileFacing) {
            EnumFacing side = TileEntityAssembly.toSide(tileFacing, this.getFace().getSide(this.currentFacing));
            this.util.setEmitter(world, pos, side, this.emitType, this.emitVisual);
            if (this.canOutput()) {
                this.util.setTarget(((ComponentLaser)this.component).areaStart, ((ComponentLaser)this.component).areaEnd);
                this.util.setMultiTarget(((ComponentLaser)this.component).minTargets, ((ComponentLaser)this.component).maxTargets);
                if (this.util.hasTargets()) {
                    this.util.fire(this.emitAmount);
                    this.markDirty();
                    this.emitType = null;
                    this.emitAmount = 0;
                }
                if (!world.field_72995_K) {
                    if (this.util.failure()) {
                        this.util.setDirty();
                        ++this.currentFacing;
                    } else if (this.util.success()) {
                        if (this.util.foundNew()) {
                            this.util.pickTarget();
                        }
                        this.markDirty();
                        if (!this.util.hasMaxTargets()) {
                            this.util.startSearch();
                        }
                    } else {
                        this.util.next();
                    }
                }
            }
        }

        public void updateArea(EnumFacing facing) {
            this.util.setTarget((Vec3i)this.toBlockPos(((ComponentLaser)this.component).areaStart, facing), (Vec3i)this.toBlockPos(((ComponentLaser)this.component).areaEnd, facing));
        }

        private BlockPos toBlockPos(Vec3i vec, EnumFacing facing) {
            EnumFacing x = TileEntityAssembly.toLocalSide(facing, EnumFacing.EAST);
            EnumFacing y = TileEntityAssembly.toLocalSide(facing, EnumFacing.UP);
            EnumFacing z = TileEntityAssembly.toLocalSide(facing, EnumFacing.SOUTH);
            int vx = vec.func_177958_n();
            int vy = vec.func_177956_o();
            int vz = vec.func_177952_p();
            return new BlockPos(vx * x.func_82601_c() + vx * y.func_82601_c() + vx * z.func_82601_c(), vy * x.func_96559_d() + vy * y.func_96559_d() + vy * z.func_96559_d(), vz * x.func_82599_e() + vz * y.func_82599_e() + vz * z.func_82599_e());
        }

        @Override
        public void update() {
            this.util.render();
            this.energy.clear();
            this.energy.putAll(this.energyCharge);
            this.energyCharge.clear();
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("energy", (NBTBase)this.writeEnergy());
            this.util.writeToNBT(compound);
            return compound;
        }

        private NBTTagList writeEnergy() {
            NBTTagList energyList = new NBTTagList();
            for (Map.Entry<String, Integer> entry : this.energy.entrySet()) {
                NBTTagCompound energy = new NBTTagCompound();
                energy.func_74778_a("type", entry.getKey());
                energy.func_74768_a("amount", entry.getValue().intValue());
                energyList.func_74742_a((NBTBase)energy);
            }
            return energyList;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            NBTTagList energyList = compound.func_150295_c("energy", 10);
            this.readEnergy(energyList);
            this.util.readFromNBT(compound);
        }

        private void readEnergy(NBTTagList energyList) {
            this.energy.clear();
            this.energyCharge.clear();
            for (NBTBase energy : energyList) {
                String type = ((NBTTagCompound)energy).func_74779_i("type");
                int amount = ((NBTTagCompound)energy).func_74762_e("amount");
                int charge = ((NBTTagCompound)energy).func_74762_e("charge");
                this.energy.put(type, amount);
                this.energyCharge.put(type, charge);
            }
        }

        public boolean canInput() {
            return ((ComponentLaser)this.component).inputAllowed;
        }

        public boolean canOutput() {
            return ((ComponentLaser)this.component).outputAllowed;
        }

        public boolean canAccept(String type) {
            return ((ComponentLaser)this.component).types.isEmpty() || ((ComponentLaser)this.component).types.contains(type);
        }

        public int getEnergy(String type) {
            return this.energy.getOrDefault(type, 0);
        }

        public int getTotalEnergy() {
            return this.energy.values().stream().mapToInt(x -> x).sum();
        }

        public int receive(String type, int i, boolean simulate) {
            int received;
            if (type == null || !this.canInput()) {
                return 0;
            }
            int n = received = i >= ((ComponentLaser)this.component).minReceive ? Math.min(i, ((ComponentLaser)this.component).maxReceive) : 0;
            if (!simulate) {
                this.energyCharge.compute(type, (k, v) -> v != null ? v + received : received);
                this.markDirty();
            }
            return received;
        }

        public void emit(String type, int energy, LaserVisual visual) {
            this.emitType = type;
            this.emitAmount = energy;
            this.emitVisual = visual;
        }
    }
}

