/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.energy.EnergyNet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentItem;
import requious.gui.slot.EnergySlot;
import requious.tile.TileEntityAssembly;
import requious.util.ComponentFace;
import requious.util.IOParameters;
import requious.util.IngredientAny;
import requious.util.ItemComponentHelper;
import requious.util.RatioConversion;
import requious.util.SlotVisual;
import requious.util.battery.BatteryAccessEmpty;
import requious.util.battery.BatteryAccessFE;
import requious.util.battery.IBatteryAccess;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.EnergySlot")
public class ComponentEnergy
extends ComponentBase {
    public boolean batteryAllowed;
    public boolean inputAllowed = true;
    public boolean outputAllowed = true;
    public boolean shiftAllowed = true;
    public boolean putAllowed = true;
    public boolean takeAllowed = true;
    public boolean dropsOnBreak = true;
    public boolean canOverfill = false;
    public Ingredient filter = new IngredientAny();
    public IOParameters pushItem = new IOParameters();
    public IOParameters pushEnergy = new IOParameters();
    public int capacity;
    public float powerLoss;
    public int maxInput = Integer.MAX_VALUE;
    public int maxOutput = 0;
    public boolean acceptsFE = true;
    public boolean acceptsEU = false;
    public RatioConversion conversionEU = new RatioConversion(4, 1);
    public String unit = "fe";
    public SlotVisual foreground = SlotVisual.EMPTY;
    public SlotVisual background = SlotVisual.ENERGY_SLOT;

    public ComponentEnergy(ComponentFace face, int capacity) {
        super(face);
        this.capacity = capacity;
    }

    @Override
    public ComponentBase.Slot createSlot() {
        return new Slot(this);
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy setAccess(boolean input, boolean output) {
        this.inputAllowed = input;
        this.outputAllowed = output;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy allowBattery(boolean input, boolean output, @Optional(valueBoolean=true) boolean drops, @Optional(valueBoolean=true) boolean shift, @Optional IIngredient ingredient) {
        this.batteryAllowed = true;
        this.putAllowed = input;
        this.takeAllowed = output;
        this.dropsOnBreak = drops;
        this.shiftAllowed = shift;
        if (ingredient != null) {
            this.filter = CraftTweakerMC.getIngredient((IIngredient)ingredient);
        }
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy setPowerLoss(float loss) {
        this.powerLoss = loss;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy allowOverfill() {
        this.canOverfill = true;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy noDrop() {
        this.dropsOnBreak = false;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy setLimits(int input, int output) {
        this.maxInput = input;
        this.maxOutput = output;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy pushItem(int size, int slot) {
        this.pushItem = new IOParameters(size, slot);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy pushItem(int size) {
        this.pushItem = new IOParameters(size);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy pushEnergy(int size) {
        this.pushEnergy = new IOParameters(size);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy acceptFE(boolean accept) {
        this.acceptsFE = accept;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy acceptEU(boolean accept) {
        this.acceptsEU = accept;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy setForeground(SlotVisualCT visual) {
        this.foreground = SlotVisualCT.unpack(visual);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentEnergy setBackground(SlotVisualCT visual) {
        this.background = SlotVisualCT.unpack(visual);
        return this;
    }

    public static class Collector
    extends ComponentBase.Collector
    implements IEnergyStorage {
        ComponentFace face;
        List<Slot> slots = new ArrayList<Slot>();
        int pushIndex;

        public Collector(ComponentFace face) {
            this.face = face;
        }

        private void addSlot(Slot slot) {
            this.slots.add(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot.getFace() == this.face && slot instanceof Slot && ((Slot)slot).acceptsFE()) {
                this.addSlot((Slot)slot);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCapability() {
            return true;
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            if (capability == CapabilityEnergy.ENERGY && this.face.matches(localSide, globalSide)) {
                return true;
            }
            return super.hasCapability(capability, localSide, globalSide);
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            if (capability == CapabilityEnergy.ENERGY && this.face.matches(localSide, globalSide)) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this);
            }
            return super.getCapability(capability, localSide, globalSide);
        }

        private boolean canAutoOutput() {
            for (Slot slot : this.slots) {
                if (!slot.getPushEnergy().active) continue;
                return true;
            }
            return false;
        }

        @Override
        public void update() {
            if (this.canAutoOutput() && this.tile instanceof TileEntityAssembly) {
                EnumFacing facing;
                BlockPos pos;
                World world = this.tile.func_145831_w();
                TileEntity checkTile = world.func_175625_s((pos = this.tile.func_174877_v()).func_177972_a(facing = TileEntityAssembly.toSide(((TileEntityAssembly)this.tile).getFacing(), this.face.getSide(this.pushIndex))));
                if (checkTile != null && checkTile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
                    IEnergyStorage battery = (IEnergyStorage)checkTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
                    for (Slot slot : this.slots) {
                        int maxSize;
                        int energy;
                        int filled;
                        if (!slot.getPushEnergy().active || (filled = battery.receiveEnergy(energy = slot.extract(maxSize = slot.getPushEnergy().size, true), false)) <= 0) continue;
                        slot.extract(filled, false);
                    }
                }
                ++this.pushIndex;
            }
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = 0;
            for (Slot slot : this.slots) {
                received += slot.receive(Math.min(maxReceive - received, slot.getMaxInput()), simulate);
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = 0;
            for (Slot slot : this.slots) {
                extracted += slot.extract(Math.min(maxExtract - extracted, slot.getMaxOutput()), simulate);
            }
            return extracted;
        }

        public int getEnergyStored() {
            int energy = 0;
            for (Slot slot : this.slots) {
                energy += slot.getAmount();
            }
            return energy;
        }

        public int getMaxEnergyStored() {
            int capacity = 0;
            for (Slot slot : this.slots) {
                capacity += slot.getCapacity();
            }
            return capacity;
        }

        public boolean canExtract() {
            for (Slot slot : this.slots) {
                if (!slot.canOutput()) continue;
                return true;
            }
            return false;
        }

        public boolean canReceive() {
            for (Slot slot : this.slots) {
                if (!slot.canInput()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Collector) {
                return this.face.equals((Object)((Collector)obj).face);
            }
            return false;
        }

        public ComponentFace getFace() {
            return this.face;
        }
    }

    public static class CollectorIC2
    extends ComponentBase.Collector {
        List<Slot> slots = new ArrayList<Slot>();
        double extraDraw = 0.0;

        private void addSlot(Slot slot) {
            this.slots.add(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot instanceof Slot && ((Slot)slot).acceptsEU()) {
                this.addSlot((Slot)slot);
                return true;
            }
            return false;
        }

        @Override
        public void update() {
        }

        public void draw(double amount) {
            amount += this.extraDraw;
            for (Slot slot : this.slots) {
                if (!slot.canOutputItem()) continue;
                int extracted = slot.extract(slot.getEUConversion().getBase((int)Math.ceil(amount)), false);
                amount -= (double)slot.getEUConversion().getUnit(extracted);
            }
            this.extraDraw = amount;
        }

        public double inject(EnumFacing localSide, EnumFacing globalSide, double amount, double voltage) {
            for (Slot slot : this.slots) {
                if (!slot.canInput() || !slot.getFace().matches(localSide, globalSide)) continue;
                int inserted = slot.receive(slot.getEUConversion().getBase((int)Math.floor(amount)), false);
                amount -= (double)slot.getEUConversion().getUnit(inserted);
            }
            return amount;
        }

        public int getInputTier() {
            int maxVoltage = 0;
            for (Slot slot : this.slots) {
                maxVoltage = Math.max(maxVoltage, slot.getEUConversion().getUnit(slot.getMaxInput()));
            }
            return EnergyNet.instance.getTierFromPower((double)maxVoltage);
        }

        public int getOutputTier() {
            int maxVoltage = 0;
            for (Slot slot : this.slots) {
                maxVoltage = Math.max(maxVoltage, slot.getEUConversion().getUnit(slot.getMaxOutput()));
            }
            return EnergyNet.instance.getTierFromPower((double)maxVoltage);
        }

        public boolean canInputEnergy(EnumFacing localSide, EnumFacing globalSide) {
            for (Slot slot : this.slots) {
                if (!slot.canInput() || !slot.getFace().matches(localSide, globalSide)) continue;
                return true;
            }
            return false;
        }

        public boolean canOutputEnergy(EnumFacing localSide, EnumFacing globalSide) {
            for (Slot slot : this.slots) {
                if (!slot.canOutputItem() || !slot.getFace().matches(localSide, globalSide)) continue;
                return true;
            }
            return false;
        }

        public double getOutputEnergy() {
            int toSend = 0;
            for (Slot slot : this.slots) {
                if (!slot.canOutputItem()) continue;
                toSend += Math.min(slot.getEUConversion().getUnit(slot.getMaxOutput()), slot.energy);
            }
            return toSend;
        }

        public double getInputEnergy() {
            int toReceive = 0;
            for (Slot slot : this.slots) {
                if (!slot.canInput()) continue;
                toReceive += slot.getEUConversion().getUnit(slot.getCapacity() - slot.energy);
            }
            return toReceive;
        }
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentEnergy>
    implements ComponentItem.IItemSlot {
        int energy;
        float powerLoss;
        ItemComponentHelper battery = new ItemComponentHelper(){

            @Override
            public int getCapacity() {
                return 1;
            }
        };
        boolean active;

        public Slot(ComponentEnergy component) {
            super(component);
        }

        public boolean acceptsFE() {
            return ((ComponentEnergy)this.component).acceptsFE;
        }

        public boolean acceptsEU() {
            return ((ComponentEnergy)this.component).acceptsEU;
        }

        public RatioConversion getEUConversion() {
            return ((ComponentEnergy)this.component).conversionEU;
        }

        public int getMaxInput() {
            return ((ComponentEnergy)this.component).maxInput;
        }

        public int getMaxOutput() {
            return ((ComponentEnergy)this.component).maxOutput;
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
            ComponentBase.Collector energy;
            ComponentItem.Collector item;
            if (this.isBatteryAccepted() && ((ComponentEnergy)this.component).batteryAllowed && !collectors.contains(item = new ComponentItem.Collector(this.getFace()))) {
                collectors.add(item);
            }
            if (this.acceptsFE() && !collectors.contains(energy = new Collector(this.getFace()))) {
                collectors.add(energy);
            }
            if (this.acceptsEU() && !collectors.contains(energy = new CollectorIC2())) {
                collectors.add(energy);
            }
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return new EnergySlot(assembly, this, x, y);
        }

        @Override
        public void update() {
            if (!this.active && this.energy > 0) {
                this.powerLoss += ((ComponentEnergy)this.component).powerLoss;
                int intLoss = (int)this.powerLoss;
                if (intLoss > 0) {
                    this.energy = Math.max(0, this.energy - intLoss);
                    this.powerLoss -= (float)intLoss;
                }
                this.markDirty();
            }
            this.active = false;
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
            if (((ComponentEnergy)this.component).dropsOnBreak) {
                this.battery.spawnInWorld(world, position);
                this.battery.setStack(ItemStack.field_190927_a);
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("energy", this.energy);
            compound.func_74776_a("loss", this.powerLoss);
            compound.func_74782_a("battery", (NBTBase)this.battery.writeToNBT(new NBTTagCompound()));
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.energy = compound.func_74762_e("energy");
            this.powerLoss = compound.func_74760_g("loss");
            this.battery.readFromNBT(compound.func_74775_l("battery"));
        }

        @Override
        public boolean acceptsItem(ItemStack stack) {
            return ((ComponentEnergy)this.component).filter.apply(stack);
        }

        @Override
        public boolean canInputItem() {
            return ((ComponentEnergy)this.component).batteryAllowed;
        }

        @Override
        public boolean canOutputItem() {
            return ((ComponentEnergy)this.component).batteryAllowed;
        }

        public boolean canInput() {
            return ((ComponentEnergy)this.component).inputAllowed;
        }

        public boolean canOutput() {
            return ((ComponentEnergy)this.component).outputAllowed;
        }

        public boolean canPut() {
            return !((ComponentEnergy)this.component).hidden && ((ComponentEnergy)this.component).batteryAllowed && ((ComponentEnergy)this.component).putAllowed;
        }

        public boolean canTake() {
            return !((ComponentEnergy)this.component).hidden && ((ComponentEnergy)this.component).takeAllowed;
        }

        public boolean canOverfill() {
            return ((ComponentEnergy)this.component).canOverfill;
        }

        public boolean isBatteryAccepted() {
            return ((ComponentEnergy)this.component).batteryAllowed;
        }

        public int getCapacity() {
            if (this.canOverfill() && this.getAmount() <= 0) {
                return Integer.MAX_VALUE;
            }
            IBatteryAccess battery = this.getBatteryStorage();
            return ((ComponentEnergy)this.component).capacity + battery.getMaxEnergyStored();
        }

        public int getAmount() {
            IBatteryAccess battery = this.getBatteryStorage();
            return this.energy + battery.getEnergyStored();
        }

        public void setAmount(int energy) {
            this.energy = energy;
        }

        private IBatteryAccess getBatteryStorage() {
            ItemStack battery;
            if (((ComponentEnergy)this.component).batteryAllowed && (battery = this.getItem().getStack()).hasCapability(CapabilityEnergy.ENERGY, null)) {
                return new BatteryAccessFE(battery, (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null));
            }
            return BatteryAccessEmpty.INSTANCE;
        }

        public String getUnit() {
            return ((ComponentEnergy)this.component).unit;
        }

        @Override
        public ItemComponentHelper getItem() {
            return this.battery;
        }

        public int receive(int amount, boolean simulate) {
            IBatteryAccess batteryAccess = this.getBatteryStorage();
            int internalReceived = Math.min(amount, this.getCapacity() - this.energy);
            int batteryReceived = batteryAccess.receiveEnergy(Math.max(amount - internalReceived, 0), simulate);
            if (!simulate) {
                this.energy += internalReceived;
                this.active = true;
                this.battery.setStack(batteryAccess.getStack());
                this.markDirty();
            }
            return internalReceived + batteryReceived;
        }

        public int extract(int amount, boolean simulate) {
            IBatteryAccess batteryAccess = this.getBatteryStorage();
            int internalExtracted = Math.min(amount, this.energy);
            int batteryExtracted = batteryAccess.extractEnergy(Math.max(amount - internalExtracted, 0), simulate);
            if (!simulate) {
                this.energy -= internalExtracted;
                this.active = false;
                this.battery.setStack(batteryAccess.getStack());
                this.markDirty();
            }
            return internalExtracted + batteryExtracted;
        }

        @Override
        public boolean isDirty() {
            return super.isDirty() || this.battery.isDirty();
        }

        @Override
        public void markClean() {
            super.markClean();
            this.battery.markClean();
        }

        public IOParameters getPushEnergy() {
            return ((ComponentEnergy)this.component).pushEnergy;
        }

        @Override
        public IOParameters getPushItem() {
            return ((ComponentEnergy)this.component).pushItem;
        }

        @Override
        public boolean canSplit() {
            return true;
        }

        @Override
        public boolean canShift() {
            return ((ComponentEnergy)this.component).shiftAllowed;
        }

        public SlotVisual getForeground() {
            return ((ComponentEnergy)this.component).foreground;
        }

        public SlotVisual getBackground() {
            return ((ComponentEnergy)this.component).background;
        }
    }
}

